/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.aep;

import com.af.plugins.ConvertTools;
import com.af.plugins.JsonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepDeviceCommandClient;
import com.ctg.ag.sdk.biz.AepDeviceCommandLwmProfileClient;
import com.ctg.ag.sdk.biz.AepDeviceManagementClient;
import com.ctg.ag.sdk.biz.aep_device_command.CreateCommandRequest;
import com.ctg.ag.sdk.biz.aep_device_command_lwm_profile.CreateCommandLwm2mProfileRequest;
import com.ctg.ag.sdk.biz.aep_device_management.CreateDeviceRequest;
import com.ctg.ag.sdk.biz.aep_device_management.DeleteDeviceRequest;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;

public class AEPTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getRet(String deviceId, String contentData) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceCommandClient client = null;
        try {
            client = (AepDeviceCommandClient)AepDeviceCommandClient.newClient().appKey(appKey).appSecret(appSecret).build();
            CreateCommandRequest request = new CreateCommandRequest();
            request.setParamMasterKey((Object)mastKey);
            request.addParamMasterKey((Object)mastKey);
            JSONObject params = new JSONObject();
            params.put("appId", (Object)appKey);
            params.put("secret", (Object)appSecret);
            params.put("deviceId", (Object)deviceId);
            params.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
            params.put("productId", (Object)WebMeterInfo.getString("appId"));
            params.put("ttl", 86400);
            JSONObject content = new JSONObject();
            content.put("dataType", 2);
            content.put("payload", (Object)contentData);
            params.put("content", (Object)content);
            byte[] bytes = ConvertTools.strToBytes((String)params.toString());
            request.setBody(bytes);
            byte[] resultByte = client.CreateCommand(request).getBody();
            JSONObject jSONObject = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
            return jSONObject;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    public static JSONObject getRetProfile(String deviceId, String contentData, String method, String serviceId) throws Exception {
        JSONObject paras = new JSONObject();
        paras.put(method, (Object)contentData);
        return AEPTools.getRetProfile(deviceId, paras, method, serviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getRetProfile(String deviceId, JSONObject contentData, String method, String serviceId) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceCommandLwmProfileClient client = null;
        try {
            client = (AepDeviceCommandLwmProfileClient)AepDeviceCommandLwmProfileClient.newClient().appKey(appKey).appSecret(appSecret).build();
            CreateCommandLwm2mProfileRequest request = new CreateCommandLwm2mProfileRequest();
            request.setParamMasterKey((Object)mastKey);
            request.addParamMasterKey((Object)mastKey);
            JSONObject params = new JSONObject();
            params.put("appId", (Object)appKey);
            params.put("secret", (Object)appSecret);
            params.put("deviceId", (Object)deviceId);
            params.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
            params.put("productId", (Object)WebMeterInfo.getString("appId"));
            params.put("ttl", 86400);
            JSONObject content = new JSONObject();
            content.put("serviceId", (Object)serviceId);
            content.put("method", (Object)method);
            content.put("paras", (Object)contentData);
            params.put("command", (Object)content);
            byte[] bytes = ConvertTools.strToBytes((String)params.toString());
            request.setBody(bytes);
            byte[] resultByte = client.CreateCommandLwm2mProfile(request).getBody();
            JSONObject result = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
            JSONObject resultData = result.getJSONObject("result");
            JSONObject jSONObject = new JSONObject().put("commandId", (Object)(resultData.getString("deviceId") + "-" + resultData.getString("commandId")));
            return jSONObject;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getRegister(String imei, String meterNumber) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceManagementClient client = null;
        try {
            client = (AepDeviceManagementClient)AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
            CreateDeviceRequest request = new CreateDeviceRequest();
            request.setParamMasterKey((Object)mastKey);
            request.addParamMasterKey((Object)mastKey);
            JSONObject count = new JSONObject();
            count.put("deviceName", (Object)meterNumber);
            count.put("deviceSn", (Object)meterNumber);
            count.put("imei", (Object)imei);
            count.put("productId", (Object)WebMeterInfo.getString("appId"));
            count.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
            JSONObject other = new JSONObject();
            other.put("autoObserver", 0);
            count.put("other", (Object)other);
            byte[] bytes = ConvertTools.strToBytes((String)count.toString());
            request.setBody(bytes);
            byte[] resultByte = client.CreateDevice(request).getBody();
            JSONObject jSONObject = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
            return jSONObject;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getDelete(String deviceId) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        String productId = WebMeterInfo.getString("appId");
        AepDeviceManagementClient client = null;
        try {
            client = (AepDeviceManagementClient)AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
            DeleteDeviceRequest request = new DeleteDeviceRequest();
            request.setParamMasterKey((Object)mastKey);
            request.setParamProductId((Object)productId);
            request.setParamDeviceIds((Object)deviceId);
            byte[] resultByte = client.DeleteDevice(request).getBody();
            JSONObject jSONObject = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
            return jSONObject;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }
}

