/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.service;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.redis.RedisUtil;
import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DeviceAlarmStrategyCompareTypeEnum;
import com.aote.webmeter.enums.DeviceAlarmStrategyLevelEnum;
import com.aote.webmeter.service.DeviceAlarmStrategyHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class AlarmStrategyService {
    private static final String CONFIG_URL = "webmeter/mainExceptions.json";
    private static final String DEFAULT_MSG_TYPE = "\u7269\u8054\u7f51\u8bbe\u5907\u62a5\u8b66\u901a\u77e5\u77ed\u4fe1";
    private static final JSONArray EXCEPTION_LIST;
    private static final String DEFAULT_EXCEPTION_MSG_TEMPLATE = "\u8bbe\u5907\u4e0a\u62a5\u7684{\u76d1\u63a7\u9879\u540d\u79f0}\u8fbe\u5230{\u544a\u8b66\u503c}\uff0c{\u544a\u8b66\u89c4\u5219}\u9608\u503c\uff1a{\u544a\u8b66\u9608\u503c}\uff0c\u89e6\u53d1{\u544a\u8b66\u7ea7\u522b}\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\uff01";
    private static final Logger LOGGER;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;

    public boolean saveExceptionArray(String deviceType, String tableName, String meterAlias, JSONObject datas) throws Exception {
        JSONObject strategyObj;
        JSONArray strategyArray = new JSONArray(EXCEPTION_LIST.toString());
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object strategyStr = redisUtil.get("IOT_SY");
        if (strategyStr != null && (strategyObj = new JSONObject(strategyStr.toString())).has(meterAlias)) {
            strategyArray.putAll(strategyObj.getJSONArray(meterAlias));
        }
        for (int i = 0; i < strategyArray.length(); ++i) {
            int times;
            boolean isException;
            String key;
            Object value;
            JSONObject strategy = strategyArray.getJSONObject(i);
            if (!strategy.has("f_alarm_item") || (value = datas.opt(key = strategy.getString("f_alarm_item"))) == null) continue;
            String errorValue = strategy.get("f_alarm_value").toString();
            switch (strategy.getString("f_compare_type")) {
                case "=": {
                    isException = value.equals(errorValue);
                    break;
                }
                case "!=": {
                    isException = !value.equals(errorValue);
                    break;
                }
                case ">": {
                    isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) > Double.doubleToLongBits(Double.parseDouble(errorValue));
                    break;
                }
                case ">=": {
                    isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) >= Double.doubleToLongBits(Double.parseDouble(errorValue));
                    break;
                }
                case "<": {
                    isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) < Double.doubleToLongBits(Double.parseDouble(errorValue));
                    break;
                }
                case "<=": {
                    isException = Double.doubleToLongBits(Double.parseDouble(value.toString())) <= Double.doubleToLongBits(Double.parseDouble(errorValue));
                    break;
                }
                default: {
                    isException = false;
                }
            }
            String exceptionTableName = deviceType.equals("\u7269\u8054\u7f51\u8868") ? "t_exception" : "t_iot_device_exception";
            JSONArray historyExceptions = this.getHistoryExceptions(deviceType, tableName, strategy, datas);
            if (historyExceptions.length() > 0) {
                JSONObject historyException = historyExceptions.getJSONObject(0);
                if (!isException) {
                    this.updateExceptionReturnToNormal(datas.get("id").toString(), historyException.get("id").toString(), exceptionTableName);
                    continue;
                }
                times = historyException.optInt("f_times", 1);
            } else {
                if (!isException) continue;
                times = 0;
            }
            int strategyTimes = strategy.optInt("f_alarm_times", 1);
            int alarmState = ++times >= strategyTimes ? 1 : 0;
            JSONObject exceptionData = this.saveExceptionData(historyExceptions, times, deviceType, tableName, meterAlias, datas, strategy, value.toString(), alarmState);
            if (alarmState != 1 || !exceptionData.opt("type").equals("add")) continue;
            int pushType = strategy.optInt("f_push_type", -1);
            if (pushType == 0 && strategy.has("f_push_params") && strategy.has("f_alarm_persons")) {
                JSONObject params = new JSONObject();
                JSONObject extraParams = new JSONObject(strategy.getString("f_push_params"));
                params.put("f_templateid", extraParams.get("templateId"));
                params.put("f_businessid", exceptionData.get("id"));
                params.put("f_send_type", (Object)DEFAULT_MSG_TYPE);
                params.put("f_orgid", exceptionData.opt("f_orgid"));
                params.put("f_orgname", exceptionData.opt("f_orgname"));
                params.put("f_userinfo_id", exceptionData.opt("f_userinfo_id"));
                params.put("f_iot_device_no", exceptionData.opt("f_iot_device_no"));
                params.put("users", (Object)new JSONArray(strategy.getString("f_alarm_persons")));
                params.put("f_content", exceptionData.get("f_error_msg"));
                RestTools.post((String)strategy.getString("f_push_url"), (JSONObject)params);
            }
            return true;
        }
        return this.hasHistoryInAlarmExceptions(deviceType, datas);
    }

    public void updateExceptionReturnToNormal(String alarmDataId, String id, String exceptionTableName) throws Exception {
        JSONObject updateEntity = new JSONObject();
        updateEntity.put("f_alarm_state", (Object)"2");
        updateEntity.put("f_eliminate_alarm_date", (Object)DateTools.getNow2());
        updateEntity.put("f_eliminate_alarm_data_id", (Object)alarmDataId);
        updateEntity.put("id", (Object)id);
        this.entityServer.partialSave(exceptionTableName, updateEntity);
    }

    public void updateExceptionReturnToNormal(String id, String exceptionTableName) throws Exception {
        this.updateExceptionReturnToNormal(null, id, exceptionTableName);
    }

    private JSONObject getExceptionDataByUploadData(JSONObject param, JSONObject datas) {
        String f_error_level = datas.get("f_error_level").toString();
        if (!(f_error_level.equals("1") || f_error_level.equals("2") || f_error_level.equals("3"))) {
            f_error_level = "1";
        }
        param.put("f_alarm_times", (Object)"1");
        param.put("f_error_level", (Object)f_error_level);
        param.put("f_error_type", datas.get("f_error_type"));
        String msg = datas.getString("f_error_msg");
        param.put("f_error_msg", (Object)msg);
        return param;
    }

    private JSONObject getExceptionDataByStrategy(String commonMapName, String tableName, String errorValue, JSONObject datas, JSONObject strategy) {
        JSONObject param = new JSONObject();
        param.put("f_strategy_id", strategy.opt("id"));
        param.put("f_error_level", strategy.get("f_alarm_level"));
        this.getAlarmItem(commonMapName, tableName, strategy);
        String alarmItem = this.getAlarmItem(commonMapName, tableName, strategy);
        param.put("f_error_type", (Object)alarmItem);
        String compareTypeStr = DeviceAlarmStrategyCompareTypeEnum.toType(strategy.get("f_compare_type").toString()).getLabel();
        param.put("f_compare_type", (Object)compareTypeStr);
        String alarmValue = strategy.opt("f_alarm_value").toString();
        param.put("f_alarm_value", (Object)alarmValue);
        param.put("f_alarm_times", strategy.opt("f_alarm_times"));
        String strategyLevel = DeviceAlarmStrategyLevelEnum.toType(strategy.opt("f_alarm_level").toString()).getLabel();
        HashMap<String, String> paramsMap = new HashMap<String, String>(5);
        paramsMap.put("\u76d1\u63a7\u9879\u540d\u79f0", alarmItem);
        paramsMap.put("\u544a\u8b66\u503c", errorValue);
        paramsMap.put("\u544a\u8b66\u89c4\u5219", compareTypeStr);
        paramsMap.put("\u544a\u8b66\u9608\u503c", alarmValue);
        paramsMap.put("\u544a\u8b66\u7ea7\u522b", strategyLevel);
        JSONArray variableArray = strategy.optJSONArray("f_alarm_variable");
        String msg = this.format(strategy.optString("f_alarm_msg", DEFAULT_EXCEPTION_MSG_TEMPLATE), paramsMap, datas, variableArray);
        param.put("f_error_msg", (Object)msg);
        return param;
    }

    private String getAlarmItem(String commonMapName, String tableName, JSONObject strategy) {
        String alarmItemValue = strategy.get("f_alarm_item").toString();
        String alarmItem = null;
        if (tableName != null) {
            alarmItem = DeviceAlarmStrategyHelper.getAlarmItem(tableName, alarmItemValue);
        }
        if (alarmItem == null) {
            alarmItem = DeviceAlarmStrategyHelper.getAlarmItem(commonMapName, alarmItemValue);
        }
        return alarmItem;
    }

    private boolean hasHistoryInAlarmExceptions(String deviceType, JSONObject datas) throws Exception {
        String columnName;
        String exceptionTableName;
        if (deviceType.equals("\u7269\u8054\u7f51\u8868")) {
            exceptionTableName = "t_exception";
            columnName = "f_meternumber";
        } else {
            exceptionTableName = "t_iot_device_exception";
            columnName = "f_iot_device_id";
        }
        return this.sqlServer.query("getExceptionInAlarmHistory", new JSONObject().put("exceptionTableName", (Object)exceptionTableName).put("columnName", (Object)columnName).put("columnNameValue", datas.get(columnName))).length() > 0;
    }

    private JSONArray getHistoryExceptions(String deviceType, String tableName, JSONObject strategy, JSONObject datas) throws Exception {
        String commonMapName;
        String columnName;
        String exceptionTableName;
        if (deviceType.equals("\u7269\u8054\u7f51\u8868")) {
            exceptionTableName = "t_exception";
            columnName = "f_meternumber";
            commonMapName = "meterCommonMap";
        } else {
            exceptionTableName = "t_iot_device_exception";
            columnName = "f_iot_device_id";
            commonMapName = "deviceCommonMap";
        }
        String alarmItem = strategy != null ? this.getAlarmItem(commonMapName, tableName, strategy) : datas.getString("f_error_type");
        return this.sqlServer.query("getExceptionHistory", new JSONObject().put("exceptionTableName", (Object)exceptionTableName).put("columnName", (Object)columnName).put("columnNameValue", datas.get(columnName)).put("errorTypeValue", (Object)alarmItem));
    }

    public JSONObject saveExceptionData(String deviceType, String tableName, String meterAlias, JSONObject datas, JSONObject strategy, String alarmItemValue, Integer alarmState) throws Exception {
        return this.saveExceptionData(null, null, deviceType, tableName, meterAlias, datas, strategy, alarmItemValue, alarmState);
    }

    public JSONObject saveExceptionData(JSONArray historyExceptions, Integer times, String deviceType, String tableName, String meterAlias, JSONObject datas, JSONObject strategy, String alarmItemValue, Integer alarmState) throws Exception {
        String exceptionTableName;
        String commonMapName;
        if (historyExceptions == null) {
            historyExceptions = this.getHistoryExceptions(deviceType, tableName, strategy, datas);
        }
        if (times == null) {
            times = 1;
        }
        if (deviceType.equals("\u7269\u8054\u7f51\u8868")) {
            commonMapName = "meterCommonMap";
            exceptionTableName = "t_exception";
        } else {
            commonMapName = "deviceCommonMap";
            exceptionTableName = "t_iot_device_exception";
        }
        if (historyExceptions.length() > 0) {
            JSONObject exceptionData = historyExceptions.getJSONObject(0);
            JSONObject updateEntity = strategy != null ? this.getExceptionDataByStrategy(commonMapName, tableName, alarmItemValue, datas, strategy) : this.getExceptionDataByUploadData(exceptionData, datas);
            updateEntity.put("f_times", (Object)times);
            updateEntity.put("f_alarm_state", (Object)alarmState);
            updateEntity.put("f_last_alarm_date", (Object)DateTools.getNow2());
            updateEntity.put("id", exceptionData.get("id"));
            this.entityServer.partialSave(exceptionTableName, updateEntity);
            exceptionData.put("type", (Object)"update");
            return exceptionData;
        }
        JSONObject param = new JSONObject();
        if (deviceType.equals("\u7269\u8054\u7f51\u8868")) {
            param.put("f_user_id", datas.opt("f_user_id"));
            param.put("f_userfiles_id", datas.opt("f_userfiles_id"));
            param.put("f_meternumber", datas.opt("f_meternumber"));
        } else {
            param.put("f_iot_device_id", datas.opt("f_iot_device_id"));
            param.put("f_iot_device_no", (Object)datas.optString("f_iot_device_no", "\u65e0\u8bbe\u5907\u53f7"));
        }
        param.put("f_userinfo_id", datas.opt("f_userinfo_id"));
        param.put("f_alias", (Object)meterAlias);
        param.put("data_id", datas.opt("id"));
        param.put("f_read_table_name", (Object)tableName);
        param.put("f_alarm_real_value", (Object)alarmItemValue);
        if (strategy != null) {
            JsonTools.addJSON((JSONObject)param, (JSONObject)this.getExceptionDataByStrategy(commonMapName, tableName, alarmItemValue, datas, strategy));
        } else {
            this.getExceptionDataByUploadData(param, datas);
        }
        param.put("f_alarm_state", (Object)alarmState);
        param.put("f_times", (Object)times);
        param.put("f_is_read", 0);
        param.put("f_filiale", datas.opt("f_filiale"));
        param.put("f_filialeids", datas.opt("f_filialeids"));
        param.put("f_filialeid", datas.opt("f_filialeid"));
        param.put("f_outlets", datas.opt("f_outlets"));
        param.put("f_orgstr", datas.opt("f_orgstr"));
        param.put("f_orgid", datas.opt("f_orgid"));
        param.put("f_depid", datas.opt("f_depid"));
        param.put("f_orgname", datas.opt("f_orgname"));
        param.put("f_depname", datas.opt("f_depname"));
        param.put("id", new JSONObject(this.entityServer.partialSave(exceptionTableName, param)).getInt("id"));
        param.put("type", (Object)"add");
        return param;
    }

    private String format(String regex, Map<String, String> paramsMap, JSONObject params, JSONArray paramNameArray) {
        String regexStr = regex;
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            regexStr = regexStr.replaceAll("\\{" + entry.getKey() + "}", entry.getValue());
        }
        if (paramNameArray != null) {
            for (Object key : paramNameArray) {
                regexStr = regexStr.replaceAll("\\{" + key + "}", params.optString(key.toString(), "null"));
            }
        }
        return regexStr;
    }

    static {
        LOGGER = Logger.getLogger(AlarmStrategyService.class);
        if (AlarmStrategyService.class.getClassLoader().getResource(CONFIG_URL) == null) {
            throw new RuntimeException("\u7f3a\u5c11\u6284\u8868\u5f02\u5e38\u8bb0\u5f55\u6620\u5c04\u914d\u7f6e\u6587\u4ef6\uff1amainExceptions.json");
        }
        EXCEPTION_LIST = JsonTools.readJsonArrayFile((String)CONFIG_URL);
        LOGGER.debug((Object)"\u52a0\u8f7d\u6284\u8868\u5f02\u5e38\u8bb0\u5f55\u6620\u5c04\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210");
    }
}

