/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.mq;

import com.aote.rs.LogicService;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.factory.annotation.Autowired;

public class LogicMessageListener
implements MessageListenerConcurrently {
    private static final Logger LOGGER = Logger.getLogger(LogicMessageListener.class);
    @Autowired
    private LogicService logicService;

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        for (MessageExt msg : msgs) {
            try {
                String logicName = msg.getTags();
                String body = new String(msg.getBody(), StandardCharsets.UTF_8);
                this.runLogic(logicName, body);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    private void runLogic(String logicName, String data) {
        try {
            this.logicService.xtSave(logicName, data);
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u3010" + logicName + "\u3011\u51fa\u73b0\u5f02\u5e38\uff1a"), (Throwable)e);
        }
    }
}

