/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.redis.RedisUtil;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.iotplatform.client.NorthApiException;
import java.io.IOException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AuthenticationTools {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTools.class);
    private static volatile CloseableHttpClient httpClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient != null) return httpClient;
        Class<AuthenticationTools> clazz = AuthenticationTools.class;
        synchronized (AuthenticationTools.class) {
            if (httpClient != null) return httpClient;
            try {
                httpClient = HttpConnectionPoolUtil.getHttpClient((LayeredConnectionSocketFactory)AuthenticationTools.initSslConfig());
            }
            catch (NorthApiException e) {
                e.printStackTrace();
            }
            return httpClient;
        }
    }

    public static String getAuthToken() {
        String secret;
        String appId;
        int isAep = IotCommonTools.getIsAep();
        if (isAep == 1) {
            appId = WebMeterInfo.getString("aepAPIKey");
            secret = WebMeterInfo.getString("aepSecret");
        } else if (isAep == 0) {
            appId = WebMeterInfo.getString("telecomAPIKey");
            secret = WebMeterInfo.getString("telecomSecret");
        } else {
            appId = WebMeterInfo.getString("telecom2APIKey");
            secret = WebMeterInfo.getString("telecom2Secret");
        }
        String token = AuthenticationTools.getToken(appId);
        if (token != null) {
            return token;
        }
        try {
            return AuthenticationTools.getWebAuthToken(appId, secret);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized String getWebAuthToken(String appId, String secret) throws IOException {
        RedisUtil redisUtil = RedisUtil.getInstance();
        String[] newAccessToken = new String[1];
        redisUtil.lock(appId, () -> {
            String token = AuthenticationTools.getToken(appId);
            if (token == null) {
                JSONObject content = new JSONObject();
                content.put("appId", (Object)appId);
                content.put("secret", (Object)secret);
                LOGGER.info((Object)(appId + ":\u8fdb\u884c\u9274\u6743\u64cd\u4f5c"));
                try {
                    JSONObject result;
                    String refreshToken = AuthenticationTools.getRefreshToken(appId);
                    if (refreshToken != null) {
                        content.put("refreshToken", (Object)refreshToken);
                        result = IotCommonTools.post(IOTBusinessTypeEnum.REFRESH_AUTH, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
                    } else {
                        result = IotCommonTools.post(IOTBusinessTypeEnum.AUTH, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
                    }
                    if (result.has("errorEntity")) {
                        throw new RuntimeException(result.toString());
                    }
                    newAccessToken[0] = result.getString("accessToken");
                    redisUtil.set(appId + "_token", (Object)newAccessToken[0], (long)(result.getInt("expiresIn") - 20));
                    String newRefreshToken = result.getString("refreshToken");
                    if (refreshToken == null || !refreshToken.equals(newRefreshToken)) {
                        redisUtil.set(appId + "_refreshToken", (Object)newRefreshToken, 43180L);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                newAccessToken[0] = token;
            }
        });
        return newAccessToken[0];
    }

    private static String getToken(String appId) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object token = redisUtil.get(appId + "_token");
        if (token != null) {
            LOGGER.info((Object)(appId + ":\u83b7\u53d6\u73b0\u6709token"));
            return String.valueOf(token);
        }
        return null;
    }

    private static String getRefreshToken(String appId) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object token = redisUtil.get(appId + "_refreshToken");
        if (token != null) {
            LOGGER.info((Object)(appId + ":\u83b7\u53d6\u73b0\u6709refresh_token"));
            return String.valueOf(token);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected static SSLConnectionSocketFactory initSslConfig() throws NorthApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

