/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.member.runInstruct;

import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.pour.PourRunLogic;
import com.aote.webmeter.common.basic.pour.PourRunLogicCall;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.InstructTemplate;
import com.aote.webmeter.common.template.builder.impl.runInstruct.RunInstructTemplateBuilder;
import com.aote.webmeter.common.template.member.saveInstruct.SaveInstructTemplate;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.MeterTableStateEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Template
public class RunInstructTemplate
extends InstructTemplate {
    @Autowired
    private InstructManage instructManage;
    private final InstructEntity instructEntity;
    private final PourRunLogic pourRunLogic;
    private final PourRunLogicCall pourRunLogicCall;
    private final JSONObject pourCallLogicParams;
    private final String moduleName;
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveInstructTemplate.class);

    public RunInstructTemplate(RunInstructTemplateBuilder builder) {
        this.instructEntity = builder.getInstructEntity();
        this.pourRunLogic = builder.getPourRunLogic();
        this.moduleName = builder.getModuleName();
        this.pourRunLogicCall = builder.getPourRunLogicCall();
        this.pourCallLogicParams = builder.getPourCallLogicParams();
    }

    @Override
    public void beforeExec() {
    }

    @Override
    public RunInstructTemplateResult exec() {
        RunInstructTemplateResult result;
        String moduleName = this.moduleName;
        if (moduleName != null) {
            WebMeterInfo.setModuleName(moduleName);
        }
        MeterTableStateEnum tableStateEnum = MeterTableStateEnum.toType(this.instructEntity.getF_meternumber());
        InstructTypeEnum type = this.instructEntity.getF_instruct_type();
        if (tableStateEnum != null && tableStateEnum != MeterTableStateEnum.NORMAL && type != InstructTypeEnum.ChangeMeter) {
            String receiveMsg = "\u5df2\u81ea\u52a8\u53d6\u6d88\uff0c\u539f\u56e0\uff1a\u8868\u6863\u6848\u72b6\u6001\u4e3a{object.f_table_state}\uff0c\u9884\u671f\u503c\uff1a\u6b63\u5e38";
            result = new RunInstructTemplateResult(InstructStateEnum.CANCELED);
            result.setReceiveMsg(receiveMsg);
        } else {
            if (this.instructEntity.getF_meternumber() != null) {
                LOGGER.info("----------{}\u5f00\u59cb\u6267\u884c{}\u6307\u4ee4--------", (Object)this.instructEntity.getF_meternumber(), (Object)type.getValue());
            } else {
                LOGGER.info("----------\u5f00\u59cb\u6267\u884c{}\u6307\u4ee4--------", (Object)type.getValue());
            }
            result = this.pourRunLogic.run(this.instructEntity);
            if (this.pourRunLogicCall != null) {
                this.pourRunLogicCall.call(result.getState(), this.instructEntity, this.pourCallLogicParams);
            }
            if (result.getIsDisableUpdate().booleanValue()) {
                LOGGER.info("\u7981\u7528\u66f4\u65b0\u6307\u4ee4\u72b6\u6001");
            }
        }
        LOGGER.info("ID\uff1a{}\uff0c\u6307\u4ee4\u7c7b\u578b\uff1a{}\uff0c\u6267\u884c\u5b8c\u6bd5\uff1a\u72b6\u6001\uff1a{}\uff0c\u4fe1\u606f\uff1a{}", new Object[]{this.instructEntity.getId(), this.instructEntity.getF_instruct_type(), result.getState(), result.getReceiveMsg()});
        return result;
    }

    @Override
    public void afterExec() {
    }

    protected InstructManage getInstructManage() {
        return this.instructManage;
    }

    protected InstructEntity getInstructEntity() {
        return this.instructEntity;
    }

    protected PourRunLogic getPourRunLogic() {
        return this.pourRunLogic;
    }

    protected PourRunLogicCall getPourRunLogicCall() {
        return this.pourRunLogicCall;
    }

    protected JSONObject getPourCallLogicParams() {
        return this.pourCallLogicParams;
    }

    protected String getModuleName() {
        return this.moduleName;
    }
}

