/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.builder;

import com.aote.webmeter.common.basic.pour.PourSaveLogic;
import com.aote.webmeter.common.template.builder.TemplateBuilder;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import org.json.JSONObject;

public abstract class SaveInstructTemplateBuilder
extends TemplateBuilder {
    private String userId;
    private InstructTypeEnum type;
    private String content;
    private String dataId;
    private String title;
    private String alias;
    private InstructInputtorEnum inputtor = InstructInputtorEnum.SYSTEM_DEFAULT;
    private String moduleName;
    private JSONObject entity;
    private PourSaveLogic pourSaveLogic;

    protected SaveInstructTemplateBuilder(String userId, InstructTypeEnum type) {
        this.setUserId(userId);
        this.setType(type);
    }

    protected SaveInstructTemplateBuilder(JSONObject entity, InstructTypeEnum type, PourSaveLogic pourSaveLogic) {
        this.setUserId(String.valueOf(entity.get("userid")));
        this.setType(type);
        this.setEntity(entity);
        this.setPourSaveLogic(pourSaveLogic);
        this.setAlias(String.valueOf(entity.get("alias")));
        String content = pourSaveLogic.run(entity).toString();
        this.setContent(content);
    }

    protected SaveInstructTemplateBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    protected SaveInstructTemplateBuilder setType(InstructTypeEnum type) {
        this.type = type;
        return this;
    }

    protected SaveInstructTemplateBuilder setContent(String content) {
        this.content = content;
        return this;
    }

    protected SaveInstructTemplateBuilder setDataId(String dataId) {
        this.dataId = dataId;
        return this;
    }

    protected SaveInstructTemplateBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    protected SaveInstructTemplateBuilder setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    protected SaveInstructTemplateBuilder setInputtor(InstructInputtorEnum inputtor) {
        this.inputtor = inputtor;
        return this;
    }

    protected SaveInstructTemplateBuilder setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public SaveInstructTemplateBuilder setEntity(JSONObject entity) {
        this.entity = entity;
        return this;
    }

    public SaveInstructTemplateBuilder setPourSaveLogic(PourSaveLogic pourSaveLogic) {
        this.pourSaveLogic = pourSaveLogic;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public InstructTypeEnum getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAlias() {
        return this.alias;
    }

    public InstructInputtorEnum getInputtor() {
        return this.inputtor;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public JSONObject getEntity() {
        return this.entity;
    }

    public PourSaveLogic getPourSaveLogic() {
        return this.pourSaveLogic;
    }
}

