/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.dao;

import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.exception.DataExceptionCallback;
import com.aote.webmeter.exception.DefaultUserFilesDataCallback;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class UserFilesDao {
    private final SqlServer sqlServer;

    public UserFilesDao(SqlServer sqlServer) {
        this.sqlServer = sqlServer;
    }

    public JSONArray getMeterInfoByCreateInstruct(String userId, String alias, DataExceptionCallback callback) throws Exception {
        String sqlName;
        String condition = CompatTools.getBasicCondition(userId);
        SaleVersionEnum saleName = WebMeterInfo.getSaleNameEnum();
        switch (saleName) {
            case SILVER_LIGHT: {
                sqlName = "yinGuangGetMeterInfoBySaveInstruct";
                break;
            }
            case SILVER_LIGHT2: {
                sqlName = "yinGuangGetMeterInfo2BySaveInstruct";
                break;
            }
            default: {
                sqlName = "getMeterInfoBySaveInstruct";
            }
        }
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("f_meter_brand", (Object)alias);
        sqlParams.put("condition", (Object)condition);
        JSONArray result = this.sqlServer.query(sqlName, sqlParams);
        Optional.ofNullable(callback).orElseGet(DefaultUserFilesDataCallback::new).checkData(result, condition);
        return result;
    }
}

