/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage.param;

import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.exception.WebmeterException;
import java.util.Arrays;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class SetInstructStateParam {
    private String id;
    private String commandId;
    private String condition;
    private InstructStateEnum state;
    private String metaData;
    private String receiveMsg;
    private String syncCommandId;

    private SetInstructStateParam() {
    }

    public String getReceiveMsg() {
        return Optional.ofNullable(this.receiveMsg).orElseGet(() -> this.state.getReceiveMsg());
    }

    public String getMetaData() {
        return Optional.ofNullable(this.metaData).map(value -> "'" + value + "'").orElse("isnull(f_instruct_meta_data,f_instruct_content)");
    }

    public String getSyncCommandId() {
        return Optional.ofNullable(this.syncCommandId).map(value -> "'" + value + "'").orElse("isnull(f_commandId,id)");
    }

    public static void main(String[] args) {
        SetInstructStateParam param = new Builder(null).build();
        System.out.println(param.getCondition());
    }

    public String getId() {
        return this.id;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public String getCondition() {
        return this.condition;
    }

    public InstructStateEnum getState() {
        return this.state;
    }

    public static class Builder {
        private final SetInstructStateParam param = new SetInstructStateParam();

        public Builder(@NotNull InstructStateEnum stateEnum) {
            this.param.state = stateEnum;
        }

        public SetInstructStateParam build() {
            this.param.condition = Optional.ofNullable(this.param.id).map(value -> "id = '" + value + "'").orElseGet(() -> Optional.ofNullable(this.param.commandId).map(value -> "f_commandId = '" + value + "'").orElseGet(() -> Optional.ofNullable(this.param.condition).orElseThrow(() -> {
                Object[] array = new String[]{"id", "commandId", "condition"};
                return new WebmeterException(BusinessExceptionCodeEnum.BUSINESS_PARAMS_NOT_FIND, "\u6784\u9020\"SetInstructStateParam\"\u65f6\u4ee5\u4e0b\u53c2\u6570\u4e4b\u4e00\u4e0d\u80fd\u4e3anull\uff1a" + Arrays.toString(array));
            })));
            return this.param;
        }

        public Builder id(String id) {
            this.param.id = id;
            return this;
        }

        public Builder commandId(String commandId) {
            this.param.commandId = commandId;
            return this;
        }

        public Builder condition(String condition) {
            this.param.condition = condition;
            return this;
        }

        public Builder metaData(String metaData) {
            this.param.metaData = metaData;
            return this;
        }

        public Builder receiveMsg(String receiveMsg) {
            this.param.receiveMsg = receiveMsg;
            return this;
        }

        public Builder syncCommandId(String syncCommandId) {
            this.param.syncCommandId = syncCommandId;
            return this;
        }
    }
}

