/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage.param;

import com.af.plugins.DateTools;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

public class SaveInstructParam {
    private InstructTypeEnum f_instruct_type;
    private String f_instruct_title;
    private InstructStateEnum f_instruct_state;
    private String f_receive_state;
    private String f_instruct_content;
    private String f_data_id;
    private String f_meteread_id;
    private String f_alias;
    private InstructInputtorEnum f_inputtor;
    private String f_info;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date f_instruct_date;

    private SaveInstructParam() {
    }

    public String getF_alias() {
        return Optional.ofNullable(this.f_alias).orElseGet(() -> WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS.getValue()));
    }

    public String getF_instruct_title() {
        return Optional.ofNullable(this.f_instruct_title).orElseGet(() -> this.f_instruct_type.getValue());
    }

    public InstructStateEnum getF_instruct_state() {
        return Optional.ofNullable(this.f_instruct_state).orElse(InstructStateEnum.READY);
    }

    public String getF_instruct_content() {
        return Optional.ofNullable(this.f_instruct_content).orElseGet(() -> new JSONObject().toString());
    }

    public InstructInputtorEnum getF_inputtor() {
        return Optional.ofNullable(this.f_inputtor).orElse(InstructInputtorEnum.SYSTEM_DEFAULT);
    }

    public Date getF_instruct_date() {
        return Optional.ofNullable(this.f_instruct_date).orElseGet(DateTools::getNow);
    }

    public String getF_receive_state() {
        return Optional.ofNullable(this.f_receive_state).orElseGet(() -> this.f_instruct_state.getReceiveMsg());
    }

    public InstructTypeEnum getF_instruct_type() {
        return this.f_instruct_type;
    }

    public String getF_data_id() {
        return this.f_data_id;
    }

    public String getF_meteread_id() {
        return this.f_meteread_id;
    }

    public String getF_info() {
        return this.f_info;
    }

    public static class Builder {
        private final SaveInstructParam param = new SaveInstructParam();

        public Builder(@NotNull InstructTypeEnum typeEnum) {
            this.param.f_instruct_type = typeEnum;
        }

        public SaveInstructParam build() {
            return this.param;
        }

        public Builder title(String title) {
            this.param.f_instruct_title = title;
            return this;
        }

        public Builder state(InstructStateEnum stateEnum) {
            this.param.f_instruct_state = stateEnum;
            return this;
        }

        public Builder contentData(String contentData) {
            this.param.f_instruct_content = contentData;
            return this;
        }

        public Builder dataId(String dataId) {
            this.param.f_data_id = dataId;
            return this;
        }

        public Builder metereadId(String metereadId) {
            this.param.f_meteread_id = metereadId;
            return this;
        }

        public Builder alias(String alias) {
            this.param.f_alias = alias;
            return this;
        }

        public Builder inputtor(InstructInputtorEnum inputtor) {
            this.param.f_inputtor = inputtor;
            return this;
        }

        public Builder info(String info) {
            this.param.f_info = info;
            return this;
        }
    }
}

