/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.common.basic.manage.param.SaveInstructParam;
import com.aote.webmeter.common.basic.manage.param.SetInstructStateParam;
import com.aote.webmeter.common.dao.InstructDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class InstructManage {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstructManage.class);
    private final SqlServer sqlServer;
    private final EntityServer entityServer;
    private final InstructDao instructDao;
    private final UserFilesDao userFilesDao;

    public InstructManage(SqlServer sqlServer, EntityServer entityServer, InstructDao instructDao, UserFilesDao userFilesDao) {
        this.sqlServer = sqlServer;
        this.entityServer = entityServer;
        this.instructDao = instructDao;
        this.userFilesDao = userFilesDao;
    }

    public String save(String userId, SaveInstructParam param) throws Exception {
        JSONArray userFilesInfo = this.userFilesDao.getMeterInfoByCreateInstruct(userId, param.getF_alias(), null);
        if (param.getF_inputtor() != InstructInputtorEnum.SYSTEM_DEFAULT && param.getF_inputtor() != InstructInputtorEnum.CHARGE) {
            if (param.getF_instruct_type() == InstructTypeEnum.ValveControl) {
                this.instructDao.updateRedundancyValveControlInstruct(userId);
            } else {
                this.instructDao.updateRedundancyOtherInstruct(userId, param.getF_instruct_type(), param.getF_instruct_title());
            }
        }
        JSONObject userFiles = userFilesInfo.getJSONObject(0);
        InstructEntity instructData = new InstructEntity.Builder(param, userFiles).build();
        String tableName = CompatTools.getInstructTableName();
        JSONObject instruct = JsonTools.convertToJson((String)this.entityServer.partialSaveByEntity(tableName, (Object)instructData));
        LOGGER.info("--------{}\u6307\u4ee4\u4fdd\u5b58\u6210\u529f--------", (Object)param.getF_instruct_type().getValue());
        return String.valueOf(instruct.get("id"));
    }

    public int setInstructState(SetInstructStateParam param) {
        String condition = param.getId() != null ? "id = '" + param.getId() + "'" : (param.getCommandId() != null ? "f_commandId = '" + param.getCommandId() + "'" : param.getCondition());
        String sendDateSql = "";
        String callBackDateSql = "";
        switch (param.getState()) {
            case SUCCESSFUL: 
            case FAILED: {
                String now = DateTools.getNow2();
                sendDateSql = "f_send_date = isnull(f_send_date,'" + now + "'), \n";
                callBackDateSql = "f_callback_date = '" + now + "', \n";
                break;
            }
            case ALREADY_SENT: {
                sendDateSql = "f_send_date = '" + DateTools.getNow2() + "', \n";
            }
        }
        String receiveMsg = param.getReceiveMsg() == null ? param.getState().getReceiveMsg() : param.getReceiveMsg();
        String metaData = param.getMetaData() == null ? "isnull(f_instruct_meta_data,f_instruct_content)" : "'" + param.getMetaData() + "'";
        String syncCommandIdSql = param.getSyncCommandId() == null ? "isnull(f_commandId,id)" : "'" + param.getSyncCommandId() + "'";
        String tableName = CompatTools.getInstructTableName();
        return this.sqlServer.runSQL("UPDATE {} SET \nF_INSTRUCT_STATE = '{}', \nF_RECEIVE_STATE = '{}', \n{}{}F_INSTRUCT_META_DATA = {}, \nF_COMMANDID = {} \nWHERE {} ", new Object[]{tableName, param.getState().getValue(), receiveMsg, sendDateSql, callBackDateSql, metaData, syncCommandIdSql, condition});
    }
}

