package com.aote.webmeter.common.template.member.saveInstruct;

import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.builder.impl.saveInstruct.SaveOpenAccountTemplateBuilder;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.CompatTools;
import lombok.AccessLevel;
import lombok.Getter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Getter(AccessLevel.PROTECTED)
@Template
public class SaveOpenAccountTemplate extends SaveInstructTemplate {

    private final Boolean isSellUpdate;

    private static final Logger LOGGER = LoggerFactory.getLogger(SaveOpenAccountTemplate.class);

    public SaveOpenAccountTemplate(SaveOpenAccountTemplateBuilder builder) {
        super(builder);
        this.isSellUpdate = builder.getIsSellUpdate();
    }

    @Override
    public void afterExec() {
        super.afterExec();
        String sellId = String.valueOf(this.getEntity().get("sellid"));
        String type = String.valueOf(this.getEntity().get("type"));
        //更新开户状态
        sqlServer.run(CompatTools.getUpdateUserFilesSql(this.getUserId(),2));
        if(isSellUpdate){
            //更新充值记录
            switch (type){
                case "充值":
                    sqlServer.run("update t_sellinggas set f_sendsuccess = '成功' where id = '{}'",sellId);
                    break;
                case "换表补气":
                    sqlServer.run(CompatTools.getUpdateSupplyGasMeterSql(sellId));
                    break;
                default:
                    throw new WebmeterException(BusinessExceptionCodeEnum.INVALID_RECHARGE_SOURCE_TYPE,"充值源信息："+ type);
            }
        }
    }
}
