/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.module.ModuleMapper;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.enums.WebmeterExceptionCodeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.WebmeterPropertiesTools;
import com.aote.webmeter.tools.sql.DataSourceDialect;
import com.aote.webmeter.tools.sql.MySQLDialect;
import com.aote.webmeter.tools.sql.OracleDialect;
import com.aote.webmeter.tools.sql.SqlServerDialect;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebMeterInfo {
    private static final Logger LOGGER = Logger.getLogger(WebMeterInfo.class);
    private static final Map<String, HashMap<String, String>> PROPERTIES_MAP;
    private static final ThreadLocal<String> MODULE_NAME;
    private static SaleVersionEnum SALE_NAME;
    private static DataSourceTypeEnum DATA_SOURCE_TYPE;
    public static final DataSourceDialect DATA_SOURCE_DIALECT;

    public static void load() {
        Map map = ModuleMapper.getMap();
        for (String moduleName : map.keySet()) {
            String modulePath = (String)((Map)map.get(moduleName)).get("path");
            HashMap<String, String> config = modulePath != null ? WebmeterPropertiesTools.readWebMeter(modulePath, moduleName) : WebmeterPropertiesTools.readWebMeter(moduleName);
            if (config == null) continue;
            PROPERTIES_MAP.put(moduleName, config);
            LOGGER.debug((Object)("\u3010" + moduleName + "\u3011\u6a21\u5757\u53c2\u6570\u6587\u4ef6\u5df2\u52a0\u8f7d"));
        }
    }

    public static void clear() {
        PROPERTIES_MAP.clear();
    }

    public static void setModuleName(String name) {
        if (!PROPERTIES_MAP.containsKey(name)) {
            throw new WebmeterException(WebmeterExceptionCodeEnum.MODULE_NOT_FIND_FAIL, "\u6a21\u5757\uff1a" + name);
        }
        MODULE_NAME.set(name);
    }

    public static void initWebmeterParams() throws WebmeterException {
        String dataSourceType;
        String saleName;
        String saleNameParam;
        HashMap<String, String> config = WebmeterPropertiesTools.readWebMeter("");
        if (config.containsKey(saleNameParam = WebmeterPropertiesEnum.SALE_NAME.getValue())) {
            saleName = config.get(saleNameParam);
            if (!SaleVersionEnum.is(saleName)) {
                throw new WebmeterException(WebmeterExceptionCodeEnum.SALE_VERSION_NOT_FIND_FAIL);
            }
        } else {
            throw new WebmeterException(WebmeterExceptionCodeEnum.SALE_VERSION_NULL_FAIL);
        }
        SALE_NAME = SaleVersionEnum.toType(saleName);
        String dataSourceParam = WebmeterPropertiesEnum.DATA_SOURCE_TYPE.getValue();
        if (config.containsKey(dataSourceParam)) {
            dataSourceType = config.get(dataSourceParam);
            if (!DataSourceTypeEnum.is(dataSourceType)) {
                throw new WebmeterException(WebmeterExceptionCodeEnum.DATA_SOURCE_TYPE_NOT_FIND_FAIL);
            }
        } else {
            throw new WebmeterException(WebmeterExceptionCodeEnum.DATA_SOURCE_TYPE_NULL_FAIL);
        }
        DATA_SOURCE_TYPE = DataSourceTypeEnum.toType(dataSourceType);
    }

    public static String getString(String key) {
        return PROPERTIES_MAP.get(MODULE_NAME.get()).get(key);
    }

    public static String getString(String key, String defaultValue) {
        String value = PROPERTIES_MAP.get(MODULE_NAME.get()).get(key);
        return value != null ? value : defaultValue;
    }

    public static Map<String, String> getMap() {
        return PROPERTIES_MAP.get(MODULE_NAME.get());
    }

    public static String getStringByModule(String moduleName, String key) {
        return PROPERTIES_MAP.get(moduleName).get(key);
    }

    public static String getModuleName() {
        return MODULE_NAME.get();
    }

    public static String getSaleName() {
        return SALE_NAME.getValue();
    }

    public static String getDataSourceType() {
        return DATA_SOURCE_TYPE.getValue();
    }

    public static SaleVersionEnum getSaleNameEnum() throws WebmeterException {
        SaleVersionEnum saleVersionEnum = SALE_NAME;
        if (saleVersionEnum == null) {
            throw new WebmeterException(WebmeterExceptionCodeEnum.SALE_VERSION_NULL_FAIL, "\u6a21\u5757\uff1a" + MODULE_NAME.get());
        }
        return saleVersionEnum;
    }

    public static DataSourceTypeEnum getDataSourceTypeEnum() throws WebmeterException {
        DataSourceTypeEnum dataSourceTypeEnum = DATA_SOURCE_TYPE;
        if (dataSourceTypeEnum == null) {
            throw new WebmeterException(WebmeterExceptionCodeEnum.DATA_SOURCE_TYPE_NULL_FAIL, "\u6a21\u5757\uff1a" + MODULE_NAME.get());
        }
        return dataSourceTypeEnum;
    }

    public static Boolean has(String key) {
        return PROPERTIES_MAP.get(MODULE_NAME.get()).containsKey(key);
    }

    public static Boolean has(String module, String key) {
        return PROPERTIES_MAP.get(module).containsKey(key);
    }

    public static void removeModuleName() {
        MODULE_NAME.remove();
    }

    public static Boolean hasModule(String key) {
        return PROPERTIES_MAP.containsKey(key);
    }

    public static void setSaleName(String saleName) {
        SALE_NAME = SaleVersionEnum.toType(saleName);
    }

    static {
        MODULE_NAME = new ThreadLocal();
        PROPERTIES_MAP = new HashMap<String, HashMap<String, String>>(1);
        WebMeterInfo.load();
        WebMeterInfo.initWebmeterParams();
        DATA_SOURCE_DIALECT = DATA_SOURCE_TYPE == DataSourceTypeEnum.SQLSERVER ? new SqlServerDialect() : (DATA_SOURCE_TYPE == DataSourceTypeEnum.ORACLE ? new OracleDialect() : new MySQLDialect());
    }
}

