package com.aote.webmeter.common.entity;

import com.aote.util.JsonHelper;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import lombok.Data;
import org.json.JSONObject;

/**
 * 指令实体
 */
@Data
public class InstructEntity {
    private String id;
    private String f_user_id;
    private String f_userfiles_id;
    private String f_userinfo_id;
    private String f_manufacturers;
    private String f_alias;
    private String f_meternumber;
    private String f_table_state;
    private String f_instruct_type;
    private String f_instruct_title;
    private String f_instruct_content;
    private String f_instruct_state;
    private String f_receive_state;
    private String f_data_id;
    private String f_meteread_id;
    private String f_info;
    private String f_inputtor;
    //分公司信息
    private String f_filiale;
    private String f_filialeid;
    private String f_filialeids;
    private String f_outlets;
    private String f_orgstr;
    private String f_orgid;
    private String f_depid;
    private String f_orgname;
    private String f_depname;

    private InstructEntity(){

    }

    public String getUserFilesId(){
        if (WebMeterInfo.getSaleNameEnum() == SaleVersionEnum.Vue_V3) {
            return f_userfiles_id;
        }
        return f_user_id;
    }

    public static InstructEntity build(JSONObject data){
        return JsonHelper.toParse(data,InstructEntity.class);
    }
}
