SELECT
	h.id,
	max(h.f_price_name) f_price_name,
	max(h.f_price1) f_price1,
	max(h.f_gas1) f_gas1,
	max(h.f_price2) f_price2,
	max(h.f_gas2) f_gas2,
	max(h.f_price3) f_price3,
	max(h.f_version) f_version,
	max(h.f_state) f_state,
	max(h.f_stairmonths) f_stairmonths,
    CONVERT(varchar(100), max(h.f_perform_date), 112) f_print_perform_date,
    max(h.f_perform_date) as f_perform_date,
	max(h.f_default) f_default
FROM
	t_userfiles f
	LEFT JOIN (
	SELECT
		p.f_price_id as id,
		p.f_price_name,
		m.f_price1,
		m.f_gas1,
		m.f_price2,
		m.f_gas2,
		m.f_price3,
		p.f_version,
		p.f_state,
		ISNULL( f_stairmonths, 12 ) f_stairmonths,
		p.f_perform_date,
		1 AS f_default
	FROM
		t_stairprice p
		LEFT JOIN (
		SELECT
			f_stairprice_id,
			MAX ( CASE f_price_name WHEN '1' THEN f_price ELSE 0 END ) AS f_price1,
			MAX ( CASE f_price_name WHEN '1' THEN f_gas ELSE 0 END ) AS f_gas1,
			MAX ( CASE f_price_name WHEN '2' THEN f_price ELSE 0 END ) AS f_price2,
			MAX ( CASE f_price_name WHEN '2' THEN f_gas ELSE 0 END ) AS f_gas2,
			MAX ( CASE f_price_name WHEN '3' THEN f_price ELSE 0 END ) AS f_price3
		FROM
			t_detailprice
		GROUP BY
			f_stairprice_id
		) m ON m.f_stairprice_id = p.id
	WHERE
		1 = 1
		AND GETDATE( ) > f_perform_date
		AND GETDATE( ) < f_end_date
		AND f_state = '有效'

	) h ON f.f_price_id = h.id
	where h.id is not null and {condition}
GROUP BY
	h.id
