select id,             //操作id
	   type,           //操作类型
	   f_describe,     //描述
	   f_state,        //状态
	   f_operator,     //操作员
	   f_operate_date,  //操作时间
	   f_userinfo_id,   //用户编号
	   f_userinfo_code,
	   f_user_id,		//表编号
	   f_userfiles_id,
	   case when type = '其他收费' then 1 else state end state,			// 显示依据
	   f_cancel_record_id,  //显示撤销操作的编号
	   f_cancel_reason,  //撤销原因
	   f_comments,  //备注
       f_user_state
from
 (
	select { entity.findDialect() == $SqlServer$: $top 20$,$$} p.*,case when f_operate_date= max_id then 1 else 0 end state
	from
	(
		select r.id,r.f_operat_type type,r.f_describe,r.f_state,r.f_operator,r.f_cancel_record_id,r.f_cancel_reason,
		r.f_operate_date,r.f_userinfo_id,r.f_userinfo_code,r.f_user_id,r.f_userfiles_id,s.max_id,f_comments,f_user_state
		from
		    (
		      select top 20
		         r.id,
             r.f_operat_type,
             r.f_describe,
             r.f_state,
             r.f_operator,
             r.f_operate_date,
             r.f_user_id,
             r.f_userfiles_id,
             u.f_userinfo_code  f_userinfo_code,
             r.f_userinfo_id,
             u.f_filialeid,
             u.f_orgid,
             u.f_user_state,
             r.f_cancel_record_id,
             r.f_cancel_reason,
             r.f_comments
          from t_record r
          left join t_userinfo u
          on r.f_userinfo_id=u.f_userinfo_id
		      where {condition} and r.f_state != '无效'
		      order by id desc
		     ) r
		    left join
		   (
		    select f_userinfo_id,MAX(f_operate_date) max_id
		    from t_record r
		    where  f_state = '有效' and f_operat_type not in ('档案变更', '发卡售气', '卡表收费', '其他收费', '其他收费撤销')
		    group by f_userinfo_id
		   ) s on r.f_userinfo_id=s.f_userinfo_id
		   { entity.findDialect() == $SqlServer$: $$,$and rownum<=20$}
   ) p { entity.findDialect() == $SqlServer$: $$,$where rownum<=20$}
 )  ss
order by f_operate_date desc
