SELECT
	s.*,
	ui.f_userinfo_code,
	e.f_bill_number,
	e.f_bill_code,
    CASE WHEN s.f_state= '有效' AND e.f_bill_state IS NULL THEN '开具发票'
        WHEN e.f_bill_state = '有效'
            AND e.f_bill_number IS NOT NULL THEN
            '发票冲红'
        WHEN s.f_state IS NULL
            AND e.f_bill_state = '有效'
            AND e.f_bill_number IS NOT NULL THEN
            '发票冲红' ELSE '无效发票'
        END f_states
FROM
	(
	SELECT
		id,
		f_userinfo_id,
		f_user_id,
		f_type type,
		f_hand_date,
		f_user_name,
		f_meternumber,
	CASE	WHEN min_tablebase IS NULL THEN
			f_last_tablebase ELSE min_tablebase
		END f_last_tablebase,
    CASE

		WHEN max_tablebase IS NULL THEN
		f_tablebase ELSE max_tablebase
	END f_tablebase,
	CAST ((
		SELECT CAST
			( f_price AS VARCHAR ) + '|'
		FROM
			t_chargeprice
		WHERE
			f_charge_id = s.id
			AND f_gas > 0
		GROUP BY
			f_price FOR xml path ( '' )) AS VARCHAR
	) f_price,
	f_pregas,
	f_preamount,
	isnull( f_delaypay, 0 ) f_delaypay,
	'' f_jianmian,
	f_balance,
--f_preamount,
	f_preamount + isnull( f_delaypay, 0 ) f_oughtfee,
	f_collection,
	f_curbalance,
	f_payment,
	f_operator,
	f_operate_date,
	f_state,
	f_depname,
	isnull( f_comments, '' ) f_comments
FROM
	t_sellinggas s
	LEFT JOIN (
	SELECT
		f_sell_id,
		MIN ( f_hand_date ) min_date,
		MAX ( f_hand_date ) max_date,
	CASE
			WHEN MIN ( f_hand_date ) = MAX ( f_hand_date ) THEN
			CONVERT ( VARCHAR ( 11 ), MIN ( f_hand_date ), 23 ) ELSE CONVERT ( VARCHAR ( 11 ), MIN ( f_hand_date ), 23 ) + '至' + CONVERT ( VARCHAR ( 11 ), MAX ( f_hand_date ), 23 )
		END f_hand_date,
	MIN ( f_last_tablebase ) min_tablebase,
	MAX ( f_tablebase ) max_tablebase
FROM
	t_handplan
WHERE
	f_meter_state = '已抄表'
	AND f_hand_state = '有效'
GROUP BY
	f_sell_id
	) h ON s.id = h.f_sell_id
WHERE
	{ condition } and f_type = '自动下账'
	) s
	LEFT JOIN t_userinfo ui ON s.f_userinfo_id= ui.f_userinfo_id
   left JOIN t_eticket e ON s.id = e.f_sell_id
ORDER BY
f_operate_date DESC
