SELECT
    type.name,
    CASE

        WHEN repair.zongshu IS NULL THEN
            0 ELSE repair.zongshu
        END AS zongshu,
    CASE

        WHEN repair.wancheng IS NULL THEN
            0 ELSE repair.wancheng
        END AS wancheng
FROM
    (
        SELECT
            '漏气隐患' AS name UNION ALL
        SELECT
            '表具故障' AS name UNION ALL
        SELECT
            '更改管线' AS name UNION ALL
        SELECT
            '工商餐饮' AS name UNION ALL
        SELECT
            '预约安检' AS name UNION ALL
        SELECT
            '阀门故障' AS name UNION ALL
        SELECT
            '用气故障' AS name UNION ALL
        SELECT
            '抢修抢险'
    ) type
        LEFT JOIN (
        SELECT
            f_repairtype,
            SUM ( zongshu ) zongshu,
            SUM ( wancheng ) wancheng
        FROM
            (
                SELECT
                    swo.f_repairtype,
                    CASE

                        WHEN swo.f_state= '撤销' THEN
                            0
                        WHEN swo.f_workorder_type= '报修单'
                            AND ( sw.f_result_status= '已完成' OR swo.f_state= '已完成' ) THEN
                            1 ELSE 0
                        END 'wancheng',
                    CASE

                        WHEN swo.f_workorder_type= '报修单' THEN
                            1 ELSE 0
                        END 'zongshu'
                FROM
                    t_serviceworkorder swo
                        LEFT JOIN t_servicework sw ON swo.id= sw.serviceid
                        LEFT JOIN t_service s ON swo.f_service_id= s.f_service_id
                WHERE
                        swo.f_workorder_type= '报修单'
                  and SUBSTRING ( swo.f_created_date, 0, 11 ) = '{yearmonthday}'

            ) tt
        GROUP BY
            f_repairtype
    ) repair ON type.name = repair.f_repairtype
