SELECT
    isnull( s0.huchutime, 0 ) huchutime,
    isnull( s1.hurutime, 0 ) hurutime,
    isnull( s2.weijie, 0 ) + isnull( s4.zizhu, 0 ) weijie,
    isnull( s3.yijie, 0 ) + isnull( s4.zizhu, 0 ) yijie
FROM
    (
        SELECT SUM
                   (
                       datediff( SECOND, comingtime, handuptime )) huchutime
        FROM
            t_call_log
        WHERE
                islink = 'BZ_CALLOUT'
          AND SUBSTRING ( comingtime, 0, 11 ) = '{startdate}'
    ) s0,
    (
        SELECT SUM
                   (
                       datediff( SECOND, starttime, endtime )) hurutime
        FROM
            t_records
        WHERE
                teltype = '呼入'
          AND len( starttime ) != 0
		AND len( endtime ) != 0
		AND SUBSTRING ( outltime, 0, 11 ) = '{startdate}'
    ) s1,
    (
        SELECT COUNT
                   ( * ) weijie
        FROM
            t_records
        WHERE
                teltype = '呼入'
          AND len( starttime ) > 0
          AND SUBSTRING ( outltime, 0, 11 ) = '{startdate}'
    ) s2,
    (
        SELECT COUNT
                   ( * ) yijie
        FROM
            t_records
        WHERE
                teltype = '呼入'
          AND len( inltime ) > 0
          AND SUBSTRING ( outltime, 0, 11 ) = '{startdate}'
    ) s3,
    (
        SELECT COUNT
                   ( * ) zizhu
        FROM
            t_records
        WHERE
                teltype = '呼入'
          AND (findtime = '' or findtime is null)
          AND SUBSTRING ( outltime, 0, 11 ) = '{startdate}'
    ) s4
