SELECT dd.gongsi,
case when aa.zixun is null then 0 else aa.zixun end as zixun,
case when bb.dianhuo is null then 0 else bb.dianhuo end as dianhuo,
case when cc.baoxiu is null then 0 else cc.baoxiu end as baoxiu

FROM
	(
	SELECT
		'五莲分公司' AS gongsi UNION ALL
	SELECT
		'日照分公司' AS gongsi UNION ALL
	SELECT
		'莒县分公司' AS gongsi UNION ALL
	SELECT
		'岚山分公司' AS gongsi UNION ALL
	SELECT
		'莒南分公司' AS gongsi
	) dd
	LEFT JOIN ( SELECT f_company, COUNT ( 0 ) AS zixun FROM t_serviceworkorder WHERE f_company IS NOT NULL
	and { startDate != $$ : $ f_created_date > '{startDate}' $,startDate == $$ : $ 1 = 1 $,$$ }
	and { endDate != $$ : $ f_created_date <= '{endDate}' $,endDate == $$ : $ 1 = 1 $,$$ }
	GROUP BY f_company
	) aa ON dd.gongsi= aa.f_company
	LEFT JOIN (
	SELECT
	CASE
			f_outlets
			WHEN '五莲一达运行部' THEN
			'五莲分公司'
			WHEN '日照一达运行部' THEN
			'日照分公司'
			WHEN '岚山中油一达运行部' THEN
			'岚山分公司'
			WHEN '莒县一达运行部' THEN
			'莒县分公司'
			WHEN '莒南中油一达运行部' THEN
			'莒南分公司' ELSE '其他'
		END AS f_outlets,
		COUNT ( 0 ) AS dianhuo
	FROM
		t_serviceworkorder
	WHERE
		f_workorder_type = '报修单'
		AND f_repairtype IN ( '点火通气', '紧急通气VIP' )
and { startDate != $$ : $ f_created_date > '{startDate}' $,startDate == $$ : $ 1 = 1 $,$$ }
and { endDate != $$ : $ f_created_date <= '{endDate}' $,endDate == $$ : $ 1 = 1 $,$$ }
	GROUP BY
		f_outlets
	) bb ON dd.gongsi= bb.f_outlets
	LEFT JOIN (
	SELECT
	CASE
			f_outlets
			WHEN '五莲一达运行部' THEN
			'五莲分公司'
			WHEN '日照一达运行部' THEN
			'日照分公司'
			WHEN '岚山中油一达运行部' THEN
			'岚山分公司'
			WHEN '莒县一达运行部' THEN
			'莒县分公司'
			WHEN '莒南中油一达运行部' THEN
			'莒南分公司' ELSE '其他'
		END AS f_outlets,
		COUNT ( 0 ) AS baoxiu
	FROM
		t_serviceworkorder
	WHERE
		f_workorder_type = '报修单'
		AND ( f_repairtype NOT IN ( '点火通气', '紧急通气VIP' ) OR f_repairtype IS NULL )
and { startDate != $$ : $ f_created_date > '{startDate}' $,startDate == $$ : $ 1 = 1 $,$$ }
and { endDate != $$ : $ f_created_date <= '{endDate}' $,endDate == $$ : $ 1 = 1 $,$$ }
	GROUP BY
	f_outlets
	) cc ON dd.gongsi= cc.f_outlets

order by dd.gongsi desc
