SELECT
    nam, --话务员
    ur.id,--工号
    SUM (zhimangcishu) AS zhimangcishu, --置忙次数
    SUM (weijie)+SUM (yijie) zongji, --来电总数
    SUM (weijie) AS weijie, --未接
    SUM (yijie) AS yijie, --已接
    SUM (weibo) AS waibo, --外拨
    SUM (quanbujieting) AS quanbujieting, --全部接听
    SUM (jieru) AS jieru, --接入
    SUM (jiechu) AS jiechu,--接出
    SUM (zixundan) AS zixundan,--咨询单
    SUM (tousudan) AS tousudan,--投诉单
    SUM (baoxiudan) AS baoxiudan,--报修单
    SUM(qiangxiu) AS qiangxius,--抢修
    SUM(fuwu) AS fuwus,--服务
    SUM(zhenggai) AS zhenggais,--整改
    SUM(zhihuantongqi) AS zhihuantongqis,--置换通气
    SUM (zixundan)+SUM (tousudan)+SUM (baoxiudan)-SUM (jieru) as shoudongluru,
    cast(cast(cast(isnull(SUM (yijie),0) as float)/max(recordnums.num)*100 as NUMERIC(6,2)) as varchar) + '%'  scale  --接线率

FROM
    (
        SELECT
            NAME AS nam,
            SUM (opspan) AS denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            T_ATTENDANT_STATUS
        WHERE
                operation = '登入'
          AND opstart >= '{startDate}'
          AND opstart <= '{endDate}'
        GROUP BY
            NAME
        UNION ALL
        SELECT
            NAME AS nam,
            0 denglushichang,
            SUM (opspan) AS zhimangshichang,
            COUNT (*) AS zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi

        FROM
            T_ATTENDANT_STATUS
        WHERE
                operation = '置忙'
          AND opstart >= '{startDate}'
          AND opstart <= '{endDate}'
        GROUP BY
            NAME
        UNION ALL
        SELECT
            telname AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            COUNT (*) AS weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_records
        WHERE
                len(starttime) = 0
          and     teltype='呼入'
          AND INLTIME >= '{startDate}'
          AND INLTIME <= '{endDate}'
        GROUP BY
            telname
        UNION ALL
        SELECT
            telname AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            COUNT (*) AS yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_records
        WHERE
            len(starttime) != 0
      and     teltype='呼入'
       AND INLTIME >= '{startDate}'
          AND INLTIME <= '{endDate}'
        GROUP BY
            telname
        UNION ALL
        SELECT
            gonghao AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            COUNT (*) AS weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            T_CALL_LOG
        WHERE
            islink = 'BZ_CALLOUT'
          AND comingtime >= '{startDate}'
          AND comingtime <= '{endDate}'
        GROUP BY
            gonghao
        UNION ALL
        SELECT
            telname AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            SUM (
            datediff(minute , starttime, endtime)
            ) AS jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_records
        WHERE
            len(starttime) != 0
          and     teltype='呼入'
          AND len(endtime) != 0
          AND INLTIME >= '{startDate}'
          AND INLTIME <= '{endDate}'
        GROUP BY
            telname
        UNION ALL
        SELECT
            telname AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            COUNT (*) AS threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_records
        WHERE
            len(starttime) != 0
          AND len(endtime) != 0
          and     teltype='呼入'
          AND datediff(minute , starttime, endtime) < 15
          AND INLTIME >= '{startDate}'
          AND INLTIME <= '{endDate}'
        GROUP BY
            telname
        UNION ALL
        SELECT
            telname AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            COUNT (*) AS quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_records
        WHERE
            len(starttime) != 0
          AND len(endtime) != 0
          and     teltype='呼入'
          AND INLTIME >= '{startDate}'
          AND INLTIME <= '{endDate}'
        GROUP BY
            telname
        UNION ALL
        SELECT
            telname AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            COUNT (*) AS jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_records
        WHERE
            len(associatedid) != 0
          and     teltype='呼入'
          AND INLTIME >= '{startDate}'
          AND INLTIME <= '{endDate}'
        GROUP BY
            telname
        UNION ALL
        SELECT
            b.nam AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            COUNT (*) AS jiechu,
            0 zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            (
            SELECT
            telname AS nam,
            associatedid
            FROM
            t_records
            WHERE
            len(associatedid) != 0
            and     teltype='呼入'
            AND INLTIME >= '{startDate}'
            AND INLTIME <= '{endDate}'
            ) b,
            (
            SELECT
            telname AS nam,
            ID
            FROM
            t_records
            WHERE
            len(associatedid) != 0
            and     teltype='呼入'
            AND INLTIME >= '{startDate}'
            AND INLTIME <= '{endDate}'
            ) c
        WHERE
            b.associatedid = c.ID
        GROUP BY
            b.nam
        UNION ALL
        SELECT
            f_operator_name AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            COUNT (*) zixundan,
            0 tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_consult
        WHERE
            f_created_date >= '{startDate}'
          AND f_created_date <= '{endDate}'
        GROUP BY
            f_operator_name
        UNION ALL
        SELECT
            f_operator_name AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            COUNT (*) tousudan,
            0 baoxiudan,
            0 qiangxiu,
            0 fuwu,
            0 zhenggai,
            0 zhihuantongqi
        FROM
            t_complaint
        WHERE
            f_created_date >= '{startDate}'
          AND f_created_date <= '{endDate}'
        GROUP BY
            f_operator_name
        UNION ALL
        SELECT
            f_attendant AS nam,
            0 denglushichang,
            0 zhimangshichang,
            0 zhimangcishu,
            0 weijie,
            0 yijie,
            0 weibo,
            0 jietingshichang,
            0 threesjieting,
            0 quanbujieting,
            0 jieru,
            0 jiechu,
            0 zixundan,
            0 tousudan,
            COUNT (*) baoxiudan,
            sum(case when  f_repairtype='抢修' then 1 else 0 end ) qiangxiu,
            sum(case when  f_repairtype='服务' then 1 else 0 end ) fuwu,
            sum(case when  f_repairtype='整改' then 1 else 0 end ) zhenggai,
            sum(case when  f_repairtype='置换通气' then 1 else 0 end ) zhihuantongqi
        FROM
            t_service
        WHERE
            f_created_date >= '{startDate}'
          AND f_created_date <= '{endDate}'
        GROUP BY
            f_attendant
    ) ttt
left join t_user ur ON ttt.nam = ur.name , ( --总来电数
SELECT count(*) num from t_records where starttime is not null and starttime !=''
and starttime>='{startDate}' and endtime<='{endDate}'
) recordnums
WHERE
    {condition} and  1=1 and nam is not null and nam != ''
GROUP BY
    nam,ur.id
ORDER BY
    nam
