SELECT
RANK() OVER (ORDER BY s0.num DESC) AS id,
s0.telname,  --话务员
s5.id telid,     --工号
cast(isnull(s0.num,0) as int)  connections,  --接线数
cast(cast(isnull(s0.num,0) as float)/z0.num*100 as NUMERIC(6,2))  scale,  --接线率
isnull(cast(cast(s4.num as FLOAT)/3600 as NUMERIC(8,2)),0)  onlinetime, --在线时长
isnull(s1.num,0)  degreenum,  --满意数
isnull(s2.num,0)  nodegreenum,  --不满意数
isnull(s3.num,0)  complaint,  --投诉数
RANK() OVER (ORDER BY s0.num DESC) AS ranking,   --排名
z0.num totalnum    --总接线
FROM
-- 接线数
(
SELECT telname,count(*) num from t_records where starttime is not null and starttime !=''
and starttime>='{startdate}' and endtime<='{enddate}' and  telname !='null'
GROUP BY telname
)s0 LEFT JOIN
-- 满意度
(
SELECT telname,count(*) num from t_records where starttime is not null and starttime !='' and degree=1
and starttime>='{startdate}' and endtime<='{enddate}'
GROUP BY telname
)s1  on s0.telname=s1.telname  LEFT JOIN
-- 满意度
(
SELECT telname,count(*) num from t_records where starttime is not null and starttime !='' and degree=3
and starttime>='{startdate}' and endtime<='{enddate}'
GROUP BY telname
)s2  on s0.telname=s2.telname  LEFT JOIN
-- 投诉数
(
SELECT  f_operator_name,count(*) num from t_complaint  where
 f_created_date>='{startdate}' and f_created_date<='{enddate}'
GROUP BY f_operator_name
)s3 on s0.telname=s3.f_operator_name LEFT JOIN
-- 在线时长
(
SELECT name,sum(opspan) num from t_attendant_status  where
 opstart>='{startdate}' and opend<='{enddate}'
GROUP BY name
)s4 on s0.telname=s4.name LEFT JOIN
-- 工号
(
SELECT  id,name from t_user
)s5 on s0.telname=s5.name,
-- 总接线数
(
SELECT count(*) num from t_records where starttime is not null and starttime !=''
and starttime>='{startdate}' and endtime<='{enddate}'
)z0

ORDER BY connections desc
