SELECT isnull(s0.huchutime, 0) huchutime,
       isnull(s1.hurutime, 0)  hurutime,
       isnull(s2.weijie, 0)    weijie,
       isnull(s3.yijie, 0)     yijie
from (
         SELECT sum(datediff(SECOND, starttime, endtime)) huchutime
         FROM t_records
         WHERE teltype = '呼出'
           and starttime >= '{startdate}'
     ) s0,
     (
         SELECT sum(datediff(SECOND, starttime, endtime)) hurutime
         FROM t_records
         WHERE teltype = '呼入'
           and len(starttime) != 0 and len (endtime) != 0 and substring(outltime,0,11)='{startdate}'
     ) s1,
     (
         SELECT count(0) as weijie
         FROM (
                  SELECT *,
                         row_number() OVER ( partition BY telnum ORDER BY outltime DESC ) AS group_idx
                  FROM t_records
                  WHERE  substring(outltime,0,11)='{startdate}'

              ) tt
         WHERE group_idx = 1
           AND isnull(starttime, '') = ''
           AND isnull(findtime, '') != ''
           AND f_flghuifang IS NULL
     ) s2,
     (
         SELECT count(*) yijie
         FROM t_records
         WHERE teltype = '呼入'
           and (len(starttime) > 0 or f_flghuifang = '已回访')
           and len(endtime) > 0
           and substring(outltime, 0, 11) = '{startdate}'
     ) s3
