/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.sql.SqlServer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="image")
@Scope(value="prototype")
@Component
@Transactional
public class ChengranService {
    @Autowired
    private SqlServer sqlServer;
    static Logger log = Logger.getLogger(ChengranService.class);
    static Map<String, String> f_state_map = new HashMap<String, String>();
    static Map<String, String> f_last_check_state_map = new HashMap<String, String>();
    static Map<String, String> f_user_type_map = new HashMap<String, String>();
    static Map<String, String> f_meter_diameter_map = new HashMap<String, String>();
    static Map<String, String> f_meter_measurement_map = new HashMap<String, String>();
    @Autowired
    private SessionFactory sessionFactory;

    @Path(value="savefile")
    @POST
    public String savefile(byte[] file, @QueryParam(value="FileName") String filename, @QueryParam(value="BlobId") String blob_id, @QueryParam(value="EntityName") String EntityName) {
        String result = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("filename", filename);
            map.put("id", blob_id);
            Session session = this.sessionFactory.getCurrentSession();
            map.put("blob", Hibernate.getLobCreator((Session)session).createBlob(file));
            session.saveOrUpdate(EntityName, map);
            session.flush();
            result = "";
            return result;
        }
        catch (Exception e) {
            throw new WebApplicationException(500);
        }
        finally {
            return result;
        }
    }

    @POST
    @Path(value="importExcel")
    @Consumes(value={"multipart/form-data"})
    @Transactional(value=Transactional.TxType.NEVER)
    public String importExcel(@FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDisposition) {
        try {
            JSONObject jo = new JSONObject();
            jo.put("code", 500);
            Workbook wb = ChengranService.getWorkBook(is);
            if (wb == null) {
                jo.put("result", (Object)"\u6253\u5f00\u5bfc\u5165\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e");
                return jo.toString();
            }
            Session session = this.sessionFactory.getCurrentSession();
            session.beginTransaction();
            String result = this.readSheet(wb, 0);
            if (result == null) {
                jo.put("result", (Object)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e");
                session.getTransaction().rollback();
                return jo.toString();
            }
            if (result.length() > 0) {
                jo.put("result", (Object)result);
                session.getTransaction().rollback();
                return jo.toString();
            }
            session.getTransaction().commit();
            return "{\"code\":200}";
        }
        catch (JSONException e) {
            return "{\"code\":500, \"result\":\"\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\"}";
        }
    }

    private String readSheet(Workbook wb, int sheetNo) {
        Sheet sheet = wb.getSheetAt(sheetNo);
        int firstRowNum = sheet.getFirstRowNum();
        int lastRowNum = sheet.getLastRowNum();
        Row row = sheet.getRow(firstRowNum);
        int firstCell = row.getFirstCellNum();
        int lastCell = firstCell + 25;
        try {
            if (!row.getCell(firstCell).getStringCellValue().equals("\u6240\u5c5e\u5206\u516c\u53f8") || !row.getCell(lastCell).getStringCellValue().equals("\u5907\u6ce8")) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        HashMap<String, String> hm = new HashMap<String, String>();
        for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; ++rowNum) {
            row = sheet.getRow(rowNum);
            if (row == null) continue;
            String[] line = new String[26];
            DataFormatter formatter = new DataFormatter();
            for (int cellNum = firstCell; cellNum <= lastCell; ++cellNum) {
                Cell cell = row.getCell(cellNum);
                line[cellNum - firstCell] = formatter.formatCellValue(cell);
            }
            String lineError = this.importARow(rowNum, line, hm);
            if (lineError == null) continue;
            return lineError;
        }
        return "";
    }

    private String importARow(int rowNum, String[] line, HashMap<String, String> checkerMap) {
        try {
            String f_card_id;
            String f_checker_id;
            this.trimAllCols(line);
            String f_checker = line[13];
            String f_subcompany = line[0];
            if (this.isNullOrEmpty(f_subcompany)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u6240\u5c5e\u5206\u516c\u53f8";
            }
            if (this.isNullOrEmpty(f_checker)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5b89\u68c0\u8d1f\u8d23\u4eba";
            }
            f_subcompany = f_subcompany.trim();
            f_checker = f_checker.trim();
            Session session = this.sessionFactory.getCurrentSession();
            if (checkerMap.containsKey(f_checker)) {
                f_checker_id = checkerMap.get(f_checker);
            } else {
                List list = session.createQuery("from t_user where name='" + f_checker + "'").list();
                if (list.size() != 1) {
                    return "\u7b2c" + rowNum + "\u884c\u627e\u4e0d\u5230\u5b89\u68c0\u5458" + f_checker;
                }
                f_checker_id = ((Map)list.get(0)).get("id") + "";
                checkerMap.put(f_checker, f_checker_id);
            }
            String f_userinfoid = line[1];
            if (this.isNullOrEmpty(f_userinfoid)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u7528\u6237\u7f16\u53f7";
            }
            f_userinfoid = f_userinfoid.trim();
            List list = session.createQuery("from t_userfiles where f_userinfoid = '" + f_userinfoid + "'").list();
            if (list.size() != 0) {
                return "\u7b2c" + rowNum + "\u884c\u7528\u6237\u7f16\u53f7\u91cd\u590d";
            }
            String f_user_name = line[2];
            if (this.isNullOrEmpty(f_user_name)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u7528\u6237\u540d";
            }
            f_user_name = f_user_name.trim();
            String f_user_phone = line[3];
            if (this.isNullOrEmpty(f_user_phone)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u7535\u8bdd";
            }
            f_user_phone = f_user_phone.trim();
            String f_residential_area = line[4];
            if (this.isNullOrEmpty(f_residential_area)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5c0f\u533a";
            }
            String f_unit = line[6];
            if (this.isNullOrEmpty(f_unit)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5355\u5143";
            }
            String f_building = line[5];
            if (this.isNullOrEmpty(f_building)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u697c\u53f7";
            }
            String f_floor = line[7];
            if (this.isNullOrEmpty(f_floor)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u697c\u5c42";
            }
            String f_room = line[8];
            if (this.isNullOrEmpty(f_room)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u623f\u53f7";
            }
            String f_address = line[9];
            if (this.isNullOrEmpty(f_address)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5730\u5740";
            }
            String f_last_check_state = line[10];
            if (this.isNullOrEmpty(f_last_check_state)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5b89\u68c0\u72b6\u6001";
            }
            if (!f_last_check_state_map.containsKey(f_last_check_state)) {
                return "\u7b2c" + rowNum + "\u884c\u5b89\u68c0\u72b6\u6001\u5fc5\u987b\u4e3a\u5165\u6237\u3001\u5230\u8bbf\u4e0d\u9047\u3001\u62d2\u68c0";
            }
            String f_last_check_date = line[12];
            if (this.isNullOrEmpty(f_last_check_date)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5b89\u68c0\u65f6\u95f4";
            }
            String f_archive_date = line[11];
            if (this.isNullOrEmpty(f_archive_date)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5efa\u6863\u65f6\u95f4";
            }
            String f_user_type = line[14];
            if (this.isNullOrEmpty(f_user_type)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u7528\u6237\u7c7b\u578b";
            }
            if (!f_user_type_map.containsKey(f_user_type)) {
                return "\u7b2c" + rowNum + "\u884c\u7528\u6237\u7c7b\u578b\u5fc5\u987b\u4e3a\u5c45\u6c11\u6216\u5546\u4e1a";
            }
            String f_state = line[15];
            if (this.isNullOrEmpty(f_state)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u6863\u6848\u72b6\u6001";
            }
            if (!f_state_map.containsKey(f_state)) {
                return "\u7b2c" + rowNum + "\u884c\u6863\u6848\u72b6\u6001\u5fc5\u987b\u4e3a\u6b63\u5e38\u3001\u6ce8\u9500\u3001\u70b9\u706b";
            }
            String f_remark = line[25];
            HashMap<String, String> map = new HashMap<String, String>();
            if ((f_last_check_date = this.formatDate(f_last_check_date)) == null) {
                return "\u7b2c" + rowNum + "\u884c\u5b89\u68c0\u65e5\u671f\u683c\u5f0f\u51fa\u9519\uff0c\u5fc5\u987b\u7c7b\u4f3c2015-5-30\u62165/30/2015";
            }
            map.put("f_last_check_date", f_last_check_date);
            map.put("f_last_check_state", f_last_check_state);
            map.put("f_checker", f_checker);
            map.put("f_checker_id", f_checker_id);
            map.put("f_user_name", f_user_name);
            map.put("f_user_phone", f_user_phone);
            map.put("f_userinfoid", f_userinfoid);
            map.put("f_subcompany", f_subcompany);
            f_archive_date = this.formatDate(f_archive_date);
            if (f_archive_date == null) {
                return "\u7b2c" + rowNum + "\u884c\u5efa\u6863\u65e5\u671f\u683c\u5f0f\u51fa\u9519\uff0c\u5fc5\u987b\u7c7b\u4f3c2015-5-30\u62165/30/2015";
            }
            map.put("f_archive_date", f_archive_date);
            map.put("f_user_type", f_user_type);
            map.put("f_residential_area", f_residential_area);
            map.put("f_building", f_building);
            map.put("f_unit", f_unit);
            map.put("f_floor", f_floor);
            map.put("f_room", f_room);
            map.put("f_address", f_address);
            map.put("f_sign", "0");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            map.put("f_inputdate", sdf.format(new Date()));
            map.put("f_state", f_state);
            if (f_remark != null) {
                map.put("f_remark", f_remark);
            }
            if (this.isNullOrEmpty(f_card_id = line[16])) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5361\u53f7";
            }
            String f_meter_no = line[17];
            if (this.isNullOrEmpty(f_meter_no)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u8868\u53f7";
            }
            String f_meter_brand = line[18];
            if (this.isNullOrEmpty(f_meter_brand)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u8868\u54c1\u724c";
            }
            String f_meter_measurement = line[19];
            if (this.isNullOrEmpty(f_meter_measurement)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u8868\u8ba1\u91cf\u7c7b\u578b";
            }
            if (!f_meter_measurement_map.containsKey(f_meter_measurement)) {
                return "\u7b2c" + rowNum + "\u884c\u8868\u8ba1\u91cf\u7c7b\u578b\u5fc5\u987b\u4e3a\u819c\u5f0f\u8868\u3001\u6d41\u91cf\u8ba1";
            }
            String f_meter_diameter = line[20];
            if (this.isNullOrEmpty(f_meter_diameter)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u8868\u5f84";
            }
            if (!f_meter_diameter_map.containsKey(f_meter_diameter)) {
                return "\u7b2c" + rowNum + "\u884c\u8868\u5f84\u5fc5\u987b\u4e3aG1.6\u3001G2.5 G4 G6  G10  G16  G25 ";
            }
            String f_meter_reading = line[21];
            if (this.isNullOrEmpty(f_meter_reading)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u57fa\u8868\u8bfb\u6570";
            }
            String f_meter_remain = line[22];
            if (this.isNullOrEmpty(f_meter_remain)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u5269\u4f59\u6c14\u91cf";
            }
            String f_meter_total = line[23];
            if (this.isNullOrEmpty(f_meter_total)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u603b\u7528\u6c14\u91cf";
            }
            String f_meter_accumulation = line[24];
            if (this.isNullOrEmpty(f_meter_accumulation)) {
                return "\u7b2c" + rowNum + "\u884c\u6ca1\u6709\u603b\u8d2d\u6c14\u91cf";
            }
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("f_userinfoid", f_userinfoid);
            map2.put("f_card_id", f_card_id);
            map2.put("f_meter_no", f_meter_no);
            map2.put("f_meter_brand", f_meter_brand);
            map2.put("f_meter_measurement", f_meter_measurement);
            map2.put("f_meter_diameter", f_meter_diameter);
            try {
                map2.put("f_meter_reading", Integer.parseInt(f_meter_reading));
            }
            catch (Exception e) {
                return "\u7b2c" + rowNum + "\u884c\u57fa\u8868\u8bfb\u6570\u4e0d\u662f\u6570\u5b57";
            }
            try {
                map2.put("f_meter_remain", Integer.parseInt(f_meter_remain));
            }
            catch (Exception e) {
                return "\u7b2c" + rowNum + "\u884c\u5269\u4f59\u6c14\u91cf\u4e0d\u662f\u6570\u5b57";
            }
            try {
                Integer.parseInt(f_meter_total);
                map2.put("f_meter_total", f_meter_total);
            }
            catch (Exception e) {
                return "\u7b2c" + rowNum + "\u884c\u603b\u7528\u6c14\u91cf\u4e0d\u662f\u6570\u5b57";
            }
            try {
                Integer.parseInt(f_meter_accumulation);
                map2.put("f_meter_accumulation", f_meter_accumulation);
            }
            catch (Exception e) {
                return "\u7b2c" + rowNum + "\u884c\u7d2f\u79ef\u8d2d\u6c14\u91cf\u4e0d\u662f\u6570\u5b57";
            }
            map.put("f_card_id", f_card_id);
            session.saveOrUpdate("t_userfiles", map);
            String f_userfile_id = (String)map.get("id");
            map2.put("f_userfile_id", f_userfile_id);
            session.save("t_meterfiles", map2);
            return null;
        }
        catch (Exception e) {
            return "\u672a\u77e5\u9519\u8bef";
        }
    }

    private void trimAllCols(String[] line) {
        for (int i = 0; i < line.length; ++i) {
            if (this.isNullOrEmpty(line[i])) continue;
            line[i] = line[i].trim();
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private String formatDate(String adate) {
        if (adate.indexOf(47) != -1) {
            return this.formatDate(adate, '/');
        }
        if (adate.indexOf(45) != -1) {
            return this.formatDate(adate, '-');
        }
        return null;
    }

    private String formatDate(String strDate, char delimiter) {
        try {
            int pos;
            Date aDate = null;
            if (delimiter == '/') {
                pos = strDate.lastIndexOf(47);
                int y = Integer.parseInt(strDate.substring(pos + 1));
                int pos2 = strDate.indexOf(47);
                int m = Integer.parseInt(strDate.substring(0, pos2));
                int d = Integer.parseInt(strDate.substring(pos2 + 1, pos));
                if (y < 1900 || y > 2050) {
                    return null;
                }
                aDate = new Date(y - 1900, m - 1, d);
            } else {
                pos = strDate.lastIndexOf(45);
                int d = Integer.parseInt(strDate.substring(pos + 1));
                int pos2 = strDate.indexOf(45);
                int y = Integer.parseInt(strDate.substring(0, pos2));
                int m = Integer.parseInt(strDate.substring(pos2 + 1, pos));
                if (y < 1900 || y > 2050) {
                    return null;
                }
                aDate = new Date(y - 1900, m - 1, d);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.format(aDate);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Workbook getWorkBook(InputStream is) {
        try {
            Workbook workbook = null;
            workbook = WorkbookFactory.create((InputStream)is);
            return workbook;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Path(value="file/{name}")
    @GET
    public String getimage(@Context HttpServletResponse response, @PathParam(value="name") String name) {
        try {
            JSONArray array = this.sqlServer.query("select f_realpath from t_files where f_filename = '" + name + "'");
            if (array.length() == 0) {
                return null;
            }
            org.json.JSONObject map = array.getJSONObject(0);
            String filename = map.getString("f_realpath");
            File file = new File(filename);
            FileInputStream in = new FileInputStream(file);
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            this.transformStream(in, os);
            in.close();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[is.available()];
            if (buffer.length == 0) {
                return;
            }
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        f_last_check_state_map.put("\u5165\u6237", "\u5165\u6237");
        f_last_check_state_map.put("\u5230\u8bbf\u4e0d\u9047", "\u5230\u8bbf\u4e0d\u9047");
        f_last_check_state_map.put("\u62d2\u68c0", "\u62d2\u68c0");
        f_state_map.put("\u6b63\u5e38", "\u6b63\u5e38");
        f_state_map.put("\u6ce8\u9500", "\u6ce8\u9500");
        f_state_map.put("\u70b9\u706b", "\u70b9\u706b");
        f_user_type_map.put("\u5c45\u6c11", "\u5c45\u6c11");
        f_user_type_map.put("\u5546\u4e1a", "\u5546\u4e1a");
        f_meter_diameter_map.put("G1.6", "G1.6");
        f_meter_diameter_map.put("G2.5", "G2.5");
        f_meter_diameter_map.put("G4", "G4");
        f_meter_diameter_map.put("G6", "G6");
        f_meter_diameter_map.put("G16", "G16");
        f_meter_diameter_map.put("G25", "G25");
        f_meter_diameter_map.put("G10", "G10");
        f_meter_measurement_map.put("\u6d41\u91cf\u8ba1", "\u6d41\u91cf\u8ba1");
        f_meter_measurement_map.put("\u819c\u5f0f\u8868", "\u819c\u5f0f\u8868");
    }
}

