//维修员地图中任务情况
SELECT
	f_order_man AS name2,
	daiwancheng,
	todaywancheng AS todaywancheng,
	todaydaiwan AS todaydaiwan,
	f_longitude,
	f_latitude,
	t_user.f_fengongsi AS f_fengongsi
FROM
	(
	SELECT
		f_order_man,
		SUM ( daiwancheng ) AS daiwancheng,
		SUM ( todaywancheng ) AS todaywancheng,
		SUM ( todaydaiwan ) AS todaydaiwan,
		SUM ( f_longitude ) AS f_longitude,
		SUM ( f_latitude ) AS f_latitude 
	FROM
		(
		SELECT
			f_order_man,
			COUNT ( * ) AS daiwancheng,
			0 todaywancheng,
			0 todaydaiwan,
			0 f_longitude,
			0 f_latitude 
		FROM
			t_service 
		WHERE
			f_finish = '待完成' 
			AND f_workorder_type = '报修单' 
			AND 1 = 1 
		GROUP BY
			f_order_man UNION ALL
		SELECT
			f_order_man,
			0 daiwancheng,
			COUNT ( * ) AS todaywancheng,
			0 todaydaiwan,
			0 f_longitude,
			0 f_latitude 
		FROM
			t_service 
		WHERE
		  {entity.findDialect()==$SqlServer$:$DATEDIFF(DAY, f_finish_date, GETDATE())$, $ROUND(TO_NUMBER(sysdate-f_finish_date))$} = 0
			AND f_workorder_type = '报修单' 
			AND f_finish = '已完成' 
			AND 1 = 1 
		GROUP BY
			f_order_man UNION ALL
		SELECT
			f_order_man,
			0 daiwancheng,
			0 todaywancheng,
			COUNT ( * ) AS todaydaiwan,
			0 f_longitude,
			0 f_latitude 
		FROM
			t_service 
		WHERE
		  {entity.findDialect()==$SqlServer$:$DATEDIFF(DAY, f_created_date, GETDATE())$,$ROUND(TO_NUMBER(sysdate-f_created_date))$} = 0
			AND f_workorder_type = '报修单' 
			AND 1 = 1 
		GROUP BY
			f_order_man UNION ALL
		SELECT
			f_user_name AS f_order_man,
			0 daiwancheng,
			0 todaywancheng,
			0 todaydaiwan,
			CAST (
			f_longitude AS DECIMAL ( 10, 7 )) AS f_longitude,
			CAST (
			f_latitude AS DECIMAL ( 10, 7 )) AS f_latitude 
		FROM
			t_phone_state 
		WHERE
			f_period = '最新' 
			AND 1 = 1 
		GROUP BY
			f_user_name,
			f_longitude,
			f_latitude 
		) a 
	GROUP BY
	f_order_man 
	) b,t_user
	where b.f_order_man = t_user.NAME
	and t_user.f_fengongsi <> ''
	and {condition}