-- 坐席数据
select
    nam, --话务员
    SUM (yijie) AS yijie, --已接
    SUM(convert(float,ROUND(jietingshichang,2))) as jietingshichang, --接听时长
    SUM(workordersum) as workordersum --工单数量
from (
         SELECT telname  AS nam,
                COUNT(*) AS yijie,
                0 jietingshichang,
                0 workordersum
         FROM t_records with (NOLOCK)
         WHERE len(starttime) != 0
           AND teltype = '呼入'
           AND telname = '{telname}'
           AND INLTIME >= dateadd(ms, 0, DATEADD(dd, DATEDIFF(dd, 0, getdate()), 0))
           AND INLTIME <= dateadd(ms, -3, DATEADD(dd, DATEDIFF(dd, -1, getdate()), 0))
         GROUP BY telname --坐席接入数量
         union all
         select telname as nam,
             0 yijie,
             SUM(datediff(s, starttime, endtime)) / 60.00 as jietingshichang,
             0 workordersum
         from t_records with (NOLOCK)
         WHERE len(starttime) != 0
           AND teltype = '呼入'
           AND len(endtime) != 0
           AND telname = '{telname}'
           AND INLTIME >= dateadd(ms, 0, DATEADD(dd, DATEDIFF(dd, 0, getdate()), 0))
           AND INLTIME <= dateadd(ms, -3, DATEADD(dd, DATEDIFF(dd, -1, getdate()), 0))
         GROUP BY telname
         union all
         select
             f_single_man as nam,
             0 yijie,
             0 jietingshichang,
             count(*) as workordersum
         from t_serviceworkorder with (NOLOCK)
         where f_created_date >= dateadd(ms, 0, DATEADD(dd, DATEDIFF(dd, 0, getdate()), 0))
           AND f_created_date <= dateadd(ms, -3, DATEADD(dd, DATEDIFF(dd, -1, getdate()), 0))
           AND f_single_man = '{telname}'
         GROUP BY f_single_man
     ) ttt
GROUP BY
    nam
