SELECT
	*
FROM
	(
		SELECT
			re. ID ID,
			re.teltype teltype,
			re.telnum telnum,
			re.telname telname,
			re. INLINE INLINE,
			re. OUTLINE OUTLINE,
			re.recordfile recordfile,
			re.outltime outltime,
			cc. TIME findtime,
			re.inltime inltime,
			re.starttime starttime,
			re.endtime endtime,
			re.savetime savetime,
			re. DEGREE DEGREE,
            re.f_flghuifang,
            case
                when ISNULL(re.starttime, '') != '' then '已接'
                when re.f_flghuifang is null then '未接/未回访'
                else '未接/'+re.f_flghuifang
                end f_phone_state,

			{entity.findDialect()==$SqlServer$:$CASE
		WHEN len (cc. TIME) = 0
		OR cc. TIME IS NULL THEN
			0
		ELSE
			datediff (ss, re.outltime, cc. TIME)
		END findcost,
		CASE
	WHEN len (cc. TIME) = 0
	OR len (re.inltime) = 0
	OR cc. TIME IS NULL THEN
		0
	ELSE
		datediff (ss, cc. TIME, re.inltime)
	END ringcost,
	CASE
WHEN len (re.starttime) = 0
OR len (re.inltime) = 0 THEN
	0
ELSE
	datediff (ss, re.inltime, re.starttime)
END incost,
 CASE
WHEN len (re.starttime) = 0
OR len (re.endtime) = 0 THEN
	0
ELSE
	datediff (ss, re.starttime, re.endtime)
END telcost,
 CASE
WHEN len (re.savetime) = 0
OR len (re.endtime) = 0 THEN
	0
ELSE
	datediff (ss, re.endtime, re.savetime)
END savecost$,

			$
			CASE
WHEN cc. TIME IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				cc. TIME,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.outltime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END findcost,
 CASE
WHEN cc. TIME IS NULL
OR re.inltime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.inltime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				cc. TIME,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END ringcost,
 CASE
WHEN re.starttime IS NULL
OR re.inltime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.starttime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.inltime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END incost,
 CASE
WHEN re.starttime IS NULL
OR re.endtime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.endtime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.starttime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END telcost,
 CASE
WHEN re.savetime IS NULL
OR re.endtime IS NULL THEN
	0
ELSE
	ROUND (
		TO_NUMBER (
			TO_DATE (
				re.savetime,
				'yyyy-mm-dd hh24:mi:ss'
			) - TO_DATE (
				re.endtime,
				'yyyy-mm-dd hh24:mi:ss'
			)
		) * 24 * 60 * 60
	)
END savecost
			$}




FROM
	t_records re
        LEFT JOIN (
            SELECT *
            FROM (
                SELECT *,
                row_number ( ) OVER ( partition BY rid ORDER BY time DESC ) AS group_idx
                FROM t_ccevents
            WHERE
                enevttype = 'FINDINLINE'
            ) tt
            WHERE
            group_idx = 1
        ) cc ON cc.rid = re. ID
	) t_records
WHERE
	{ condition }
ORDER BY
    { orderitem }
