select *,
       telinnum - sucnum                                                                       as nonum,
       case snum when 0 then 0 else convert(decimal(10, 2), 100.0 * finishnum / snum) end      as finishrate, -- 完工率
       case telinnum when 0 then 0 else convert(decimal(10, 2), 100.0 * sucnum / telinnum) end as telrate     -- 接听率
from (select name,-- 分公司名
             isnull(telinnum, 0)                        as telinnum,-- 呼入总数
             isnull(sucnum, 0)                          as sucnum,-- 成功接听数
             isnull(solvenum, 0)                        as solvenum,-- 热线解决数
             isnull(dispatchnum, 0)                     as dispatchnum,-- 热线派单数
             isnull(finishnum, 0)                       as finishnum, -- 完工数
             isnull(delnum, 0)                          as delnum, -- 作废数
             isnull(dispatchnum, 0) - isnull(delnum, 0) as snum -- 热线派单数 - 作废数
      from (select name from t_organization where parentname = '富瑞能源' or name = '富瑞能源') t3
               left join (select (case when ur.f_orgname is null then '富瑞能源' else ur.f_orgname end) as filiale,
                                 count(*)                                                               as telinnum
                          from (select (substring(outltime, 0, 11) + ' 00:00:00') outltime, telnum
                                from t_records
                                where outltime is not null
                                  and outltime != ''
                                  and teltype = '呼入'
                                group by substring(outltime, 0, 11), telnum) re
                                   left join AFproduct.dbo.t_userinfo ur on re.telnum = ur.f_user_phone and re.telnum !='' and ur.f_user_phone !=''
                          where outltime between '{startDate}' and '{endDate}'
                          group by ur.f_orgname) t4 on t3.name = t4.filiale
               left join (select (case when ur.f_orgname is null then '富瑞能源' else ur.f_orgname end) as filiale,
                                 count(*)                                                               as sucnum
                          from (select (substring(outltime, 0, 11) + ' 00:00:00') outltime, telnum
                                from t_records
                                where outltime is not null
                                  and outltime != ''
                                  and teltype = '呼入'
                                  and isnull(starttime, '') != ''
                                group by substring(outltime, 0, 11), telnum) re
                                   left join AFproduct.dbo.t_userinfo ur on re.telnum = ur.f_user_phone and re.telnum !='' and ur.f_user_phone !=''
                          where outltime between '{startDate}' and '{endDate}'
                          group by ur.f_orgname) t5 on t3.name = t5.filiale
               left join (select t2.f_filiale as filiale,
                                 count(*)     as solvenum
                          from t_complanintend t1
                                   left join t_serviceworkorder t2 on t1.serviceid = t2.id
                          where t1.f_handlings = '处理'
                            and t1.f_date between '{startDate}' and '{endDate}'
                          group by t2.f_filiale) t6 on t3.name = t6.filiale
               left join (SELECT t2.f_filiale as filiale, count(*) as dispatchnum
                          FROM t_records t1
                                   JOIN t_serviceworkorder t2 ON t1.id = t2.f_records_id
                          WHERE t2.f_created_date between '{startDate}' and '{endDate}'
                          GROUP BY t2.f_filiale) t7 on t3.name = t7.filiale
               left join (select t1.f_filiale as filiale,
                                 count(*)     as finishnum
                          from t_records t3
                                   join t_serviceworkorder t1
                                   join (select processid from activityins where defname = '维修完成') t2
                                        on t1.f_processid = t2.processid
                                        on t1.f_records_id = t3.id
                          where t1.f_created_date between '{startDate}' and '{endDate}'
                          group by t1.f_filiale) t8 on t3.name = t8.filiale
               left join (select f_filiale as filiale,
                                 count(*)  as delnum
                          from t_serviceworkorder
                          where f_state = '撤销'
                            and f_created_date between '{startDate}' and '{endDate}'
                          group by f_filiale) t9 on t3.name = t9.filiale) t1
order by sucnum desc
