/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.module.ModuleMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Path(value="safeUpload")
@Component
@Transactional
public class UploadImgPlugin {
    static Logger log = Logger.getLogger(UploadImgPlugin.class);
    @Autowired
    private EntityServer entityServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/fileUpload")
    @POST
    public void uploadImage(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam(value="filename") String filename, @QueryParam(value="module") String module, @FormDataParam(value="formFile") InputStream inputStream) {
        log.debug((Object)("\u7167\u7247\u4e0a\u4f20\u53c2\u6570\u4e3a" + filename + "" + ObjectUtils.isEmpty((Object)inputStream)));
        JSONObject json = new JSONObject();
        PrintWriter out = null;
        response.setContentType("application/json;charset=utf-8");
        int readLength = -1;
        try {
            byte[] by = new byte[1000];
            readLength = inputStream.read(by);
        }
        catch (IOException by) {
            // empty catch block
        }
        if (ObjectUtils.isEmpty((Object)inputStream) || readLength == -1) {
            json.put("code", 502);
            json.put("msg", (Object)("\u670d\u52a1\u5668\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + filename + "\uff0c\u8bf7\u5c06\u672c\u5730\u56fe\u7247\u5220\u9664"));
            json.put("data", (Object)"");
        } else {
            String realPath = this.uploadFileTo(inputStream, filename, module);
            JSONObject map = new JSONObject();
            try {
                if (StringUtils.isEmpty((String)realPath)) {
                    log.debug((Object)"\u4e0a\u4f20\u5931\u8d25");
                    json.put("code", 500);
                    json.put("msg", (Object)("\u6587\u4ef6\uff1a" + filename + "\u4e0a\u4f20\u5931\u8d25"));
                    json.put("data", (Object)"");
                } else {
                    log.debug((Object)("\u6587\u4ef6\uff1a" + filename + "\u4e0a\u4f20\u6210\u529f\u3002\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u4e3a" + realPath));
                    String filetype = filename.split("\\.")[1];
                    map.put("f_filename", (Object)filename);
                    String uploaddate = this.getFileUploadDate();
                    map.put("f_uploaddate", (Object)uploaddate);
                    map.put("f_filetype", (Object)filetype);
                    map.put("f_realpath", (Object)realPath);
                    map.put("f_downloadpath", (Object)realPath);
                    JSONObject result = new JSONObject(this.entityServer.partialSave("t_files", map));
                    json.put("code", 200);
                    json.put("msg", (Object)("\u6587\u4ef6\uff1a" + filename + "\u4e0a\u4f20\u6210\u529f\u3002\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u4e3a" + realPath));
                    json.put("data", (Object)result);
                }
            }
            catch (Exception e) {
                log.error((Object)("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef\uff1a" + e.getMessage()));
                log.debug((Object)("\u6587\u4ef6\uff1a" + filename + "\u4e0a\u4f20\u6210\u529f\uff0c\u4f46\u6570\u636e\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u4e3a:" + realPath + "\u4fdd\u5b58\u6570\u636e\u53c2\u6570\u4e3a\uff1a" + map));
                json.put("code", 501);
                json.put("msg", (Object)("\u6587\u4ef6\uff1a" + filename + "\u4e0a\u4f20\u6210\u529f\uff0c\u4f46\u6570\u636e\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u8def\u5f84\u4e3a:" + realPath));
                json.put("data", (Object)"");
            }
        }
        try {
            out = response.getWriter();
            out.write(JSONObject.valueToString((Object)json));
        }
        catch (IOException e) {
            log.error((Object)"BaseAction::writerJson catch exception:", (Throwable)e);
        }
        finally {
            this.closeStream(out, inputStream);
        }
    }

    private void closeStream(PrintWriter out, InputStream inputStream) {
        if (out != null) {
            out.close();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFileTo(InputStream inputStream, String filename, String module) {
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            String safecheckImagePath = "";
            String realpath = ModuleMapper.getAttr((String)module, (String)"upload");
            String safecheckBin = System.getProperty("user.dir");
            safecheckImagePath = StringUtils.isEmpty((String)realpath) || "".equals(realpath) ? safecheckBin + File.separator + "safecheck" : realpath;
            String realPath = this.getRealPath(safecheckImagePath);
            realPath = realPath + File.separator + filename;
            long size = 0L;
            in = new BufferedInputStream(inputStream);
            out = new BufferedOutputStream(new FileOutputStream(realPath));
            int len = -1;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                ((BufferedOutputStream)out).write(b, 0, len);
                size += (long)len;
            }
            String string = realPath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (!ObjectUtils.isEmpty((Object)in)) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (!ObjectUtils.isEmpty((Object)out)) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    private String getFileUploadDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        System.out.println(path);
        in.close();
        return path;
    }

    private String getRealPath(String realpath) {
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            return realpath;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

