/*
 * Decompiled with CFR 0.152.
 */
package com.aote.plugin;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class GeoTransPlugin {
    public void transform(JSONArray locs, String url) throws Exception {
        for (int i = 0; i < locs.length(); ++i) {
            this.transform(locs.getJSONObject(i), url);
        }
    }

    private void transform(JSONObject loc, String url) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("wgs84Lng", loc.getString("f_longitude")));
        nameValuePairs.add(new BasicNameValuePair("wgs84Lat", loc.getString("f_latitude")));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException();
        }
        String xml = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        xml = xml.substring(xml.indexOf("\">", 0) + 2);
        xml = xml.substring(0, xml.indexOf("</string>")).trim();
        String[] ll = xml.split("\\|");
        loc.put("f_longitude", (Object)ll[0]);
        loc.put("f_latitude", (Object)ll[1]);
    }

    public JSONObject getLLByPlumbId(String transUrl, String gisUrl) throws Exception {
        JSONObject jo = this.fetchXY(gisUrl);
        this.reverse(jo, transUrl);
        return jo;
    }

    private JSONObject fetchXY(String gisUrl) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(gisUrl);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException();
        }
        String r = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        JSONObject jo = new JSONObject(r).getJSONArray("features").getJSONObject(0);
        return jo;
    }

    private void reverse(JSONObject loc, String transUrl) throws Exception {
        HttpPost httpPost = new HttpPost(transUrl);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("localX", loc.getString("x")));
        nameValuePairs.add(new BasicNameValuePair("localY", loc.getString("y")));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException();
        }
        String xml = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        xml = xml.substring(xml.indexOf("\">", 0) + 2);
        xml = xml.substring(0, xml.indexOf("</string>")).trim();
        String[] ll = xml.split("\\|");
        loc.put("f_longitude", (Object)ll[0]);
        loc.put("f_latitude", (Object)ll[1]);
    }
}

