package com.aote.rs;

import com.aote.entity.EntityServer;

import com.aote.module.ModuleMapper;
import org.apache.commons.lang.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

/**
 * @author ZhangJunJie
 * @Date 2022-08-08
 * <p>
 * 概要：图片上传
 */
@Path("safeUpload")
@Component
@Transactional
public class UploadImgPlugin {
    static Logger log = Logger.getLogger(UploadImgPlugin.class);
    @Autowired
    private EntityServer entityServer;

    @Path("/fileUpload")
    @POST
    public void uploadImage (
            @Context HttpServletRequest request, @Context HttpServletResponse response,
            @QueryParam("filename") String filename,
            @QueryParam("module") String module,
            @FormDataParam("formFile")InputStream inputStream ) {
        log.debug("照片上传参数为" + filename +""+ObjectUtils.isEmpty(inputStream));
        JSONObject json = new JSONObject();
        PrintWriter out = null;
        response.setContentType("application/json;charset=utf-8");
        int readLength = -1;
        try {
            byte[] by =new byte[1000];
            readLength = inputStream.read(by);
        } catch (IOException e) {}
        if (ObjectUtils.isEmpty(inputStream) || readLength == -1) {
            json.put("code",502);
            json.put("msg","服务器读取文件失败：" + filename + "，请将本地图片删除");
            json.put("data","");
        } else {
            String realPath = uploadFileTo(inputStream, filename,module);
            JSONObject map = new JSONObject();
            try {
                if (StringUtils.isEmpty(realPath)) {
                    log.debug("上传失败");
                    json.put("code",500);
                    json.put("msg","文件：" + filename + "上传失败");
                    json.put("data","");
                } else {
                    log.debug("文件：" + filename + "上传成功。当前文件存储路径为" + realPath);
                    // 把文件路径存入文件映射表
                    String filetype = filename.split("\\.")[1];
                    map.put("f_filename", filename);
                    String uploaddate = getFileUploadDate();
                    map.put("f_uploaddate", uploaddate);
                    map.put("f_filetype", filetype);
                    map.put("f_realpath", realPath);
                    map.put("f_downloadpath", realPath);
                    JSONObject result = new JSONObject(entityServer.partialSave("t_files", map));
                    json.put("code",200);
                    json.put("msg","文件：" + filename + "上传成功。当前文件存储路径为" + realPath);
                    json.put("data",result);
                }
            } catch (Exception e) {
                log.error("文件上传错误：" + e.getMessage());
                log.debug("文件：" + filename + "上传成功，但数据保存失败。当前文件存储路径为:" + realPath + "保存数据参数为：" + map);
                json.put("code",501);
                json.put("msg","文件：" + filename + "上传成功，但数据保存失败。当前文件存储路径为:" + realPath);
                json.put("data","");
            }
        }
        try {
            out = response.getWriter();
            out.write(JSONObject.valueToString(json));
        } catch (IOException e) {
            log.error("BaseAction::writerJson catch exception:",e);
        } finally {
            closeStream(out,inputStream);
        }
    }

    private void closeStream(PrintWriter out,InputStream inputStream) {
        if (out != null) {
            out.close();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 文件上传
     * @param inputStream
     * @param filename
     * @return
     */
    private String uploadFileTo (InputStream inputStream,String filename,String module) {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            String safecheckImagePath = "";
            String realpath = ModuleMapper.getAttr(module, "upload");
            String safecheckBin = System.getProperty("user.dir");
            if (StringUtils.isEmpty(realpath) || "".equals(realpath)) {
                safecheckImagePath = safecheckBin + File.separator + "safecheck";
            } else {
                safecheckImagePath = realpath;
            }
            // 按当前时间年月日 创建文件夹
            String realPath = getRealPath(safecheckImagePath);
            // 返回路径后拼接 文件名
            realPath = realPath + File.separator + filename;
            //将文件流(InputStream)写入文件
            long size = 0;
            in = new BufferedInputStream(inputStream);
            out = new BufferedOutputStream(new FileOutputStream(realPath));
            int len = -1;
            byte[] b = new byte[1024];
            while((len = in.read(b)) != -1){
                out.write(b, 0, len);
                size += len;
            }
            return realPath;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            try {
                if (!ObjectUtils.isEmpty(in)) {
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (!ObjectUtils.isEmpty(out)) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }
    private String getFileUploadDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }
    public String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        System.out.println(path);
        in.close();
        return path;
    }
    // 按系统日期，建立不同文件夹，获取建立的文件夹位置
    private String getRealPath(String realpath) {
        // 进入模块文件夹
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);
        try {
            if (!f.exists()) {
                f.mkdirs();
            }
            return realpath;
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
