package com.aote.rs;

import com.af.plugins.RestTools;
import com.af.plugins.RestTools2;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class GBKTest {
    public static void main(String[] args) {
        String s = null;
        try {
            s = "https://api.ums86.com:9600/sms/Api/Send.do?SpCode=269429&LoginName=hz_trq&Password=df31ff8a8ff713ab8ed8bccb574217ff&MessageContent="
                    + URLEncoder.encode("尊敬的用户张三，感谢您致电汉中天然气服务专线96777，汉中天然气公司全体员工竭诚为您提供更优质的服务。回复TD拒收","GBK")
                    +"&UserNumber=15719139564&SerialNumber=9999&templateId=2241012037169";
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Content-Type", "application/x-www-form-urlencoded;charset=GBK");
        jsonObject.put("Accept", "text/html, application/xhtml+xml, image/jxr, */*");
        String s1 = RestTools.get(s,jsonObject);
        System.out.println(s1);
        System.out.println(getUTF8StringFromGBKString(s1));

    }

    public static String getUTF8StringFromGBKString(String gbkStr) {
        try {
            return new String(getUTF8BytesFromGBKString(gbkStr), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new InternalError();
        }
    }

    public static byte[] getUTF8BytesFromGBKString(String gbkStr) {
        int n = gbkStr.length();
        byte[] utfBytes = new byte[3 * n];
        int k = 0;
        for (int i = 0; i < n; i++) {
            int m = gbkStr.charAt(i);
            if (m < 128 && m >= 0) {
                utfBytes[k++] = (byte) m;
                continue;
            }
            utfBytes[k++] = (byte) (0xe0 | (m >> 12));
            utfBytes[k++] = (byte) (0x80 | ((m >> 6) & 0x3f));
            utfBytes[k++] = (byte) (0x80 | (m & 0x3f));
        }
        if (k < utfBytes.length) {
            byte[] tmp = new byte[k];
            System.arraycopy(utfBytes, 0, tmp, 0, k);
            return tmp;
        }
        return utfBytes;
    }
}
