package com.aote.rs;
import com.aote.entity.EntityServer;
import com.aote.module.ModuleMapper;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import javax.ws.rs.*;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

@Path("file")
@Component
@Transactional
public class FileService {

    static Logger log = Logger.getLogger(FileService.class);

    @Autowired
    private SessionFactory sessionFactory;

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private SqlServer sqlServer;
    private String getRealPath(String realpath) {
        Date d = new Date();
        realpath = realpath + File.separator + (d.getYear() + 1900) + File.separator + (d.getMonth() + 1) + File.separator + d.getDate();
        File f = new File(realpath);

        try {
            if (!f.exists()) {
                f.mkdirs();
            }

            return realpath;
        } catch (RuntimeException var5) {
            throw var5;
        } catch (Exception var6) {
            throw new RuntimeException(var6);
        }
    }
    public String getFileUploadDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }
    // 保存文件
    @SuppressWarnings("finally")
    @Path("savefile_new")
    @POST
    public String savefile(byte[] file, @QueryParam("filename") String filename, @QueryParam("module") String module) throws Exception {
            log.debug("进入文件上传 名称----"+filename);
            log.debug("文件大小----"+file.length);
            if(file.length == 0){
                throw new RuntimeException("上传文件大小为0");
            }
            String realpath = ModuleMapper.getAttr(module, "upload");
            realpath = this.getRealPath(realpath) + File.separator + filename;
            File f=new File(realpath);
            DataOutputStream dOutputStream =
                    new DataOutputStream(new FileOutputStream(f));
            dOutputStream.write(file);
            dOutputStream.close();
            log.debug("写完后文件大小----"+f.length());
            // 把文件路径存入文件映射表
            String filetype = filename.split("\\.")[1];
            JSONObject map = new JSONObject();
            map.put("f_filename", filename);
            String uploaddate = getFileUploadDate();
            map.put("f_uploaddate", uploaddate);
            map.put("f_filetype", filetype);
            map.put("f_realpath", realpath);
            map.put("f_downloadpath", realpath);
            JSONObject result = new JSONObject(entityServer.partialSave("t_files", map));
            return result.getString("id");
    }

    public static void main(String[] args) {
        long i=0;
        System.out.println(i==0);
    }
}
