package com.aote.plugin;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import com.aote.sql.SqlServer;

public class ServiceNoGenerator {

	public String getNo(SqlServer sql, String key, String number) throws Exception {
		//key 传入工单编号规则 日期截止  eg：BXC0525     number：日期后边需要多少位编号
		Session session = sql.getSessionFactory().getCurrentSession();
		SQLQuery sq = session
				.createSQLQuery("select count(*) c from t_serviceworkorder where f_service_id like :id");
		// 保证取到的单号连续
		synchronized (ServiceNoGenerator.class) {
			Object obj = sq.addScalar("c").setParameter("id", key + "%")
					.uniqueResult();
			key += String.format("%"+number+"s", (Integer.parseInt(obj.toString()) + 1) + "")
					.replace(" ", "0");
			key = key.substring(key.length()-Integer.parseInt(number));
		}
		return key;
	}
}
