package com.aote.plugin;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class AccessToken {
	private static Logger log = Logger.getLogger(AccessToken.class);

	private static String access_token;
	public static String url;
	
	public static void refreshToken() {
		int n = 5;
		while(n > 0) {
			HttpClient client = new DefaultHttpClient();
			HttpGet request = new HttpGet(url);
			try {
				HttpResponse response = client.execute(request);
				System.out.println("" + response.getStatusLine());
				if(response.getStatusLine().getStatusCode() == 200) {
					JSONObject jo = new JSONObject(EntityUtils.toString(response.getEntity()));
					synchronized(AccessToken.class) {
						access_token = jo.getString("access_token");
					}
					log.debug("newly acquired access token:" + access_token);
				}
				n = 0;
			} catch (Exception e) {
				e.printStackTrace();
				try {
					Thread.sleep(30000);
				} catch (InterruptedException e1) {
					e1.printStackTrace();
				}
				n--;
			}
		}
	}
	
	public static String getAccessToken() {
		synchronized(AccessToken.class) {
			log.debug("获取Access Token:" + access_token);
			if(access_token == null) {
				Thread t = new RefreshThread();
				t.start();
				refreshToken();
			}
			return access_token;
		}
	}
	
	private static class RefreshThread extends Thread{

		@Override
		public void run() {
			super.run();
			for(;;) {
				try {
					//refresh every 3/2 hours
					Thread.sleep(3 * 60 * 60 * 1000 / 2 );
					refreshToken();
				}
				catch(Exception e) {
					//there is nothing we can do about it
				}
			}
		}
		
	}

}
