package com.aote.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;

public class InformPlugin {
	private static Logger log = Logger.getLogger(InformPlugin.class);
	
	public static String removeInformUrl = "http://192.168.2.54/WebSiteWarm/API/Del/DropMessage";
	
	private class Stat {
		public String guid;
		public int cnt;
		public String actor;
	}
	
	/**
	 * 确认已经查看工单
	 * @param params 包含removeUrl和notifId两个参数
	 * @throws Exception
	 */
	public void confirm(JSONObject params, SqlServer sql) throws Exception {
		JSONArray rows = this.getAllNotifierRelated(params.getString("notifId"), sql);
		for(int i=0; i<rows.length(); i++) {
			JSONObject row = rows.getJSONObject(0);
			String id = row.getInt("id") + "";
			removeNotifier(removeInformUrl, id);
			sql.runSQL("delete from t_notifier where id=" + id);
		}
		
	}
	
	/**
	 * 进行全局通知
	 * @param params
	 * @param undos
	 * @param sql
	 * @param entity
	 * @return
	 * @throws Exception
	 */
	public String inform(JSONObject params, JSONArray undos, SqlServer sql, EntityServer entity) {
		try {
			//无代办，退出
			if(undos.length() == 0)
				return null;
			
			String addNotifierUrl = params.getString("addNotifierUrl");
			String updateNotifierUrl = params.getString("updateNotifierUrl");
			JSONObject activities = params.getJSONObject("activities");
			JSONObject urls = params.getJSONObject("urls");
			JSONObject corUrls = params.getJSONObject("corUrls");
			JSONObject modules = params.getJSONObject("modules");
			HashMap<String, String> guids = new HashMap<String, String>();
			String strids = "";
			int maxId = 0;
			// <活动名, 通知区显示名>
			HashMap<String, String> hints = new HashMap<String, String>();
			// [活动名 , [用户名, [guid, cnt]]] 
			HashMap<String, HashMap<String, Stat>> activityUserStatMap = new HashMap<String, HashMap<String, Stat>>();
			Iterator<String> itr = activities.keys();
			while(itr.hasNext()) {
				String key = itr.next();
				String value = activities.getString(key);
				hints.put(key, value);
				// to be filled
				activityUserStatMap.put(key, new HashMap<String, Stat>());
			}
			
			// iterate to get all userids
			for(int i = 0; i < undos.length(); i++) {
				JSONObject undo = undos.getJSONObject(i);
				// 顺便找出最大的id
				int id = undo.getInt("id");
				maxId = maxId < id ? id : maxId;
				// 工作流活动类型
				String activity = undo.getString("defname");
				if(hints.containsKey(activity)) {
					// 如果有执行者
					if(undo.has("actor")) {
						JSONObject group = undo.getJSONObject("actor");
						// 如果有执行者
						if(group.has("f_person")) {
							JSONArray executors = group.getJSONArray("f_person");
							for(int j = 0; j < executors.length(); j++) {
								JSONObject operator = executors.getJSONObject(j);
								String userid = operator.getString("userid");
								if(!guids.containsKey(userid)) {
									guids.put(userid, null);
									strids += "'"  + userid + "' ,";
								}
							}
						}
					}
				}
			}
			
			// find all the guids
			findAndFillGuids(guids, strids.substring(0, strids.length()-1), sql);
			
			// loop again to get statistics by activity and userid
			for(int i = 0; i < undos.length(); i++) {
				JSONObject undo = undos.getJSONObject(i);
				String activity = undo.getString("defname");
				if(hints.containsKey(activity)) {
					if(undo.has("actor")) {
						JSONObject group = undo.getJSONObject("actor");
						if(group.has("f_person")) {
							JSONArray executors = group.getJSONArray("f_person");
							for(int j = 0; j < executors.length(); j++) {
								JSONObject operator = executors.getJSONObject(j);
								String userid = operator.getString("userid");
								String guid = guids.get(userid);
								if(guid == null)
									continue;
								HashMap<String, Stat> aus = activityUserStatMap.get(activity);
								if(!aus.containsKey(userid)) {
									Stat stat = new Stat();
									stat.guid = guid;
									stat.cnt = 1;
									stat.actor = group.getString("id");
									aus.put(userid, stat);
								}
								else {
									Stat stat = aus.get(userid);
									stat.cnt++;
									aus.put(userid, stat);
								}
							}
						}
					}
				}
			}
			
			// handle statistics
			Set<String> msgTypes = activityUserStatMap.keySet();
			for(String msgType : msgTypes) {
				HashMap<String, Stat> userMap = activityUserStatMap.get(msgType);
				Set<String> users = userMap.keySet();
				for(String user : users) {
					Stat stat = userMap.get(user);
					String guid = stat.guid;
					int cnt = stat.cnt;
					String actor = stat.actor;
					msgType = hints.get(msgType);
					String notifierId = getNotifierId(msgType, actor, user, guid, sql);
					String cosUrl = corUrls.getString("fallback") + "?type=station";
					String url = urls.getString("fallback") + "?type=station";
					String module = modules.getString("fallback");
					if(corUrls.has(actor)) {
						cosUrl = corUrls.getString(actor)  + "?type=monitor";
					}				
					if(urls.has(actor)) {
						url = urls.getString(actor) + "?type=monitor";
					}
					if(modules.has(actor)) {
						module = modules.getString(actor);
					}
					
					// if not notified, add record and add notification
					if(notifierId == null) {
						addBothNotifier(addNotifierUrl, msgType, actor, user, guid, cnt, url, cosUrl, module, sql, entity);
					} else{
						// else update and update notification
						updateBothNotifier(updateNotifierUrl, notifierId, msgType, actor, user, guid, cnt, url, cosUrl, module, sql, entity);
					}
				}
			}
			
			return maxId + "";
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	private void updateBothNotifier(String url, String notifierId, String msgType, String actor, String user, String guid, int cnt, String redirect, String corUrl, String module, SqlServer sql, EntityServer entity) throws Exception {
		JSONObject jo = new JSONObject();
		String content = msgType + "个数: " + cnt;
		jo.put("id", Integer.parseInt(notifierId));
		jo.put("activity", msgType);
		jo.put("actor", actor);
		jo.put("f_user_guid", guid);
		jo.put("f_user_id", user);
		jo.put("f_msg_cnt", cnt);
		jo.put("f_title", msgType);
		jo.put("f_content", msgType);
		jo.put("f_redirect_url", content);
		jo.put("f_status", "placeholder");
		entity.partialSave("t_notifier", jo);
		corUrl += "?notifId=" + notifierId;
		redirect += "?notifId=" + notifierId;
		this.updateNotifier(url, guid, notifierId, msgType, content, redirect, corUrl, "placeholder", module);
	}

	private void addBothNotifier(String url, String msgType, String actor, String user, String guid, int cnt, String redirect, String corUrl, String module, SqlServer sql, EntityServer entity) throws Exception {
		JSONObject jo = new JSONObject();
		String content = msgType + "个数: " + cnt;
		jo.put("activity", msgType);
		jo.put("actor", actor);
		jo.put("f_user_guid", guid);
		jo.put("f_user_id", user);
		jo.put("f_msg_cnt", cnt);
		jo.put("f_title", msgType);
		jo.put("f_content", content);
		jo.put("f_redirect_url", redirect);
		jo.put("f_status", "placeholder");
		String id = new JSONObject(entity.partialSave("t_notifier", jo)).getString("id");
		corUrl += "&notifId=" + id;
		redirect += "&notifId=" + id;
		this.addNotifier(url, guid, id, msgType, content, redirect, corUrl, "placeholder", module);
	}

	private String getNotifierId(String actor, String msgType, String user, String guid, SqlServer sql) throws Exception {
		JSONObject jo = new JSONObject();
		jo.put("items", "id");
		jo.put("tablename", "t_notifier");
		jo.put("condition", "f_user_id='" + user + "'"
				+ " and f_title = '" + msgType + "'"
				+ " and actor = '" + actor + "'"
				+ " and activity = '" + msgType + "'"
				+ " and f_user_guid='" + guid + "'");
		JSONArray rows = sql.query("querySingleTable", jo);
		if(rows.length() == 0)
			return null;
		else {
			String id = rows.getJSONObject(0).getInt("id") + "";
			return id;
		}
	}

	private JSONArray getAllNotifierRelated(String id, SqlServer sql) throws Exception {
		JSONObject jo = new JSONObject();
		jo.put("items", "a.id");
		jo.put("tablename", "t_notifier a, (select * from t_notifier where id=" + id + ") b");
		jo.put("condition", "a.actor = b.actor and a.activity = b.activity");
		return sql.query("querySingleTable", jo);
	}

	private void findAndFillGuids(HashMap<String, String> guids, String strids, SqlServer sql) throws Exception {
		JSONObject jo = new JSONObject();
		jo.put("items", "name, f_name");
		jo.put("tablename", "t_user");
		jo.put("condition", "name in (" + strids + ")");
		JSONArray users = sql.query("querySingleTable", jo);
		for(int i=0; i<users.length(); i++) {
			JSONObject user = users.getJSONObject(i);
			String name = user.getString("name");
			if(guids.containsKey(name)) {
				//冒充管理员 disguised as the administrator
				if(user.isNull("f_name"))
					guids.put(name, "282d0196-108a-4c6b-99fa-5ce91e4999cb");
				else
					guids.put(name,  user.getString("f_name"));
			}
		}
	}

	
	/**
	 * 添加全局通知
	 * @param addNotifierUrl 添加全局通知url http://192.168.2.54/WebSiteWarm/API/Insert/RealTimeRemind
	 * @param userGuid  被通知的用户guid
	 * @param notifierId      通知id
	 * @param title     通知标题 
	 * @param content   通知内容 
	 * @param redirectUrl 点击通知重定向url
	 * @param status   状态，金剑接口要求，为数据状态比如未完成，未在界面显示
	 * @return
	 * @throws Exception 
	 */
	public boolean addNotifier(String addNotifierUrl, String userGuid, String notifierId, String title, String content, String redirectUrl, String corUrl, String status, String module) throws Exception {
		String body = "{str:\"{'userguid':'%s','msgtype':'%s','status':'%s','httpurl':'%s', 'cosurl':'%s', 'title':'%s','contentstr':'%s','bussinesid': '%s', 'wintitle':'%s'}\"}"; 
		HttpPost httpPost = new HttpPost(addNotifierUrl);
		// 2 代表工单
		body = String.format(body, userGuid, "2", status, redirectUrl, corUrl, title, content, notifierId, module);
        httpPost.setHeader(HTTP.CONTENT_TYPE, "application/json");
        httpPost.setEntity(new StringEntity(body, "UTF-8"));
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpPost);
        if(response.getStatusLine().getStatusCode() != 200) 
        	throw new IOException();
        String s =  EntityUtils.toString(response.getEntity(), "UTF8");
        return s.equals("\"1\"");
	}
	
	/**
	 * 修改全局通知
	 * @param updateNotifierUrl 修改全局通知url http://192.168.2.54/WebSiteWarm/API/edit/EditMessage
	 * @param userGuid  被通知的用户guid
	 * @param notifierId      通知id
	 * @param title     修改通知标题 
	 * @param content   修改通知内容 
	 * @param redirectUrl 修改点击通知重定向url
	 * @param status   修改状态，金剑接口要求，为数据状态比如未完成，未在界面显示
	 * @return
	 * @throws Exception 
	 */	
	public boolean updateNotifier(String updateNotifierUrl, String userGuid, String notifierId, String title, String content, String redirectUrl, String corUrl, String status, String module) throws Exception {
		return addNotifier(updateNotifierUrl, userGuid, notifierId, title, content, redirectUrl, corUrl, status, module);
	}
	
	
	/**
	 * 移除notifierId对应的通知
	 * @param removeNotifierUrl 移除服务url http://192.168.2.54/WebSiteWarm/API/Del/DropMessage
	 * @param notifierId 通知id
	 * @return
	 * @throws Exception 
	 */
	public boolean removeNotifier(String removeNotifierUrl, String notifierId) throws Exception {
		String body = "{str:\"{'msgtype':'%s','bussinesid': '%s'}\"}"; 
		HttpPost httpPost = new HttpPost(removeNotifierUrl);
		// 2 代表工单
		body = String.format(body, "2", notifierId);
        httpPost.setHeader(HTTP.CONTENT_TYPE, "application/json");
        httpPost.setEntity(new StringEntity(body, "UTF-8"));
        HttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(httpPost);
        if(response.getStatusLine().getStatusCode() != 200) 
        	throw new IOException();
        String s =  EntityUtils.toString(response.getEntity(), "UTF8");
        return s.equals("\"1\"");
	}
	
	
}
