select param.f_param_id, f_orgid, f_orgname, name, f_bank_name,f_operator,paramid.sum from (
                                                                                               {entity.findDialect()==$SqlServer$:
$
SELECT f_param_id,
       MAX(a.[f_orgid])   AS f_orgid,
       MAX(a.[f_orgname]) AS f_orgname,
       MAX(a.[name])      AS name,
       MAX(a.[f_operator])      AS f_operator,
       MAX(a.[银行名称])      AS f_bank_name
FROM (
         SELECT f_param_id,
                f_key,
                f_value
         FROM t_equipment_param param WITH (nolock)
     ) tt PIVOT ( MAX(tt.f_value) FOR tt.f_key IN ( [f_orgid],[f_orgname],[name],[银行名称],[f_operator] ) ) a
GROUP BY a.f_param_id
$,
$
select listagg(f_orgid, '') within group ( ORDER BY f_param_id )   f_orgid,
       listagg(f_orgname, '') within group ( ORDER BY f_param_id ) f_orgname,
       listagg(name, '') within group ( ORDER BY f_param_id )      name,
       listagg(f_bank_name, '') within group ( ORDER BY f_param_id )      f_bank_name,
       listagg(f_operator, '') within group ( ORDER BY f_param_id )      f_operator,
       F_PARAM_ID
from (
         select case when f_key = 'f_orgid' then f_value else '' end   f_orgid,
                case when f_key = 'f_orgname' then f_value else '' end f_orgname,
                case when f_key = 'name' then f_value else '' end      name,
                case when f_key = '银行名称' then f_value else '' end      f_bank_name,
                case when f_key = 'f_operator' then f_value else '' end      f_operator,
                f_param_id
         from t_equipment_param)
group by F_PARAM_ID
$}
) param
                                                                                               left join (
    select f_param_id, count(f_param_id) sum
    from t_equipment
    group by f_param_id
) paramid on paramid.f_param_id = param.f_param_id
where { condition }