/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.entity.EntityServer;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="db")
@Scope(value="prototype")
@Component
@Transactional
public class DBService {
    static Logger log = Logger.getLogger(DBService.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Path(value="meta2")
    @POST
    @Produces(value={"application/json"})
    public String getMetaOfTables() throws Exception {
        EntityServer es = new EntityServer();
        Field sf = es.getClass().getDeclaredField("sessionFactory");
        sf.setAccessible(true);
        sf.set(es, this.sessionFactory);
        es.loadMetaData();
        HashMap map = new HashMap();
        for (String key : EntityServer.entityLiftMap.keySet()) {
            map.put(key, EntityServer.entityLiftMap.get(key));
        }
        EntityServer.metaMap.put("_entityLiftMap_", map);
        return new JSONObject((Map)EntityServer.metaMap).toString();
    }

    @Path(value="meta")
    @POST
    @Produces(value={"application/json"})
    public String getMetaOfTables(String tables) throws Exception {
        return this.getMeta(tables).toString();
    }

    public JSONObject getMeta(@QueryParam(value="tables") String entityName) throws Exception {
        String[] entities = entityName.split(",");
        JSONObject result = new JSONObject();
        for (String entity : entities) {
            JSONArray associations = new JSONArray();
            JSONArray columns = new JSONArray();
            ClassMetadata cmd = this.sessionFactory.getClassMetadata(entity);
            JSONObject joProperties = new JSONObject();
            joProperties.put("__table__", (Object)this.removeSchema(((AbstractEntityPersister)cmd).getTableName()));
            joProperties.put("__columns__", (Object)columns);
            for (String property : cmd.getPropertyNames()) {
                Type type = cmd.getPropertyType(property);
                if (type instanceof CollectionType) {
                    CollectionType st = (CollectionType)type;
                    SessionFactoryImplementor sf = (SessionFactoryImplementor)this.sessionFactory;
                    Joinable ja = st.getAssociatedJoinable(sf);
                    String idName = cmd.getIdentifierPropertyName();
                    Type idType = cmd.getIdentifierType();
                    JSONObject jo = new JSONObject();
                    jo.put("entity", (Object)entity);
                    jo.put("table", (Object)this.removeSchema(((AbstractEntityPersister)cmd).getTableName()));
                    jo.put("key", (Object)idName);
                    jo.put("type", (Object)idType.getName());
                    jo.put("collection", (Object)ja.getName().substring(entity.length() + 1));
                    EntityPersister ps = sf.getEntityPersister(entity);
                    CascadeStyle[] ccs = ps.getPropertyCascadeStyles();
                    String ccsOptions = "";
                    for (CascadeStyle cs : ccs) {
                        ccsOptions = ccsOptions + "," + cs;
                    }
                    jo.put("cascade", (Object)(ccsOptions.length() > 0 ? ccsOptions.substring(1).replace("STYLE_NONE,", "").replace("[", "").replace("]", "") : ""));
                    String[] foreignKeys = ja.getKeyColumnNames();
                    jo.put("entity2", (Object)st.getAssociatedEntityName(sf));
                    jo.put("table2", (Object)this.removeSchema(ja.getTableName()));
                    jo.put("key2", (Object)foreignKeys[0]);
                    associations.put((Object)jo);
                    continue;
                }
                if (type instanceof ManyToOneType) continue;
                String columnName = ((AbstractEntityPersister)cmd).getPropertyColumnNames(property)[0];
                JSONObject colJo = new JSONObject();
                colJo.put("attr", (Object)property);
                colJo.put("column", (Object)columnName);
                colJo.put("type", (Object)type.getName());
                columns.put((Object)colJo);
                joProperties.put(columnName, (Object)type.getName());
            }
            String idName = cmd.getIdentifierPropertyName();
            Type idType = cmd.getIdentifierType();
            JSONObject jp = new JSONObject();
            jp.put("id", (Object)idName);
            jp.put("type", (Object)idType.getName());
            joProperties.put("__primary__key__", (Object)jp);
            joProperties.put(idName, (Object)idType.getName());
            joProperties.put("__associations__", (Object)associations);
            result.put(entity, (Object)joProperties);
        }
        return result;
    }

    private String removeSchema(String tableName) {
        if (tableName.contains(".")) {
            return tableName.substring(tableName.indexOf(46) + 1);
        }
        return tableName;
    }

    @GET
    @Path(value="/one/{hql}")
    @Produces(value={"application/json"})
    public String queryOne(@PathParam(value="hql") String hql) {
        log.debug((Object)hql);
        JSONObject result = new JSONObject();
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.createQuery(hql);
        List list = query.list();
        if (list.size() != 1) {
            throw new WebApplicationException(500);
        }
        Map map = (Map)list.get(0);
        result = this.MapToJson(map);
        log.debug((Object)result.toString());
        return result.toString();
    }

    private JSONObject MapToJson(Map<String, Object> map) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            try {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) {
                    value = JSONObject.NULL;
                } else if (value instanceof PersistentSet) {
                    PersistentSet set = (PersistentSet)value;
                    value = this.ToJson(set);
                }
                if (key.equals("$type$")) {
                    json.put("EntityType", value);
                    continue;
                }
                if (value instanceof Date) {
                    Date d1 = (Date)value;
                    Calendar c = Calendar.getInstance();
                    long time = d1.getTime() + (long)c.get(15);
                    json.put(key, time);
                    continue;
                }
                if (value instanceof HashMap) {
                    JSONObject json1 = this.MapToJson((Map)value);
                    json.put(key, (Object)json1);
                    continue;
                }
                json.put(key, value);
            }
            catch (JSONException e) {
                throw new WebApplicationException(400);
            }
        }
        return json;
    }

    private Object ToJson(PersistentSet set) {
        if (!set.wasInitialized()) {
            return JSONObject.NULL;
        }
        JSONArray array = new JSONArray();
        for (Object obj : set) {
            Map map = (Map)obj;
            JSONObject json = this.MapToJson(map);
            array.put((Object)json);
        }
        return array;
    }

    @Path(value="hql")
    @POST
    @Produces(value={"application/json"})
    public String executeHql(String hql) {
        hql = hql.replace("|", "/");
        log.debug((Object)hql);
        JSONArray array = new JSONArray();
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.createQuery(hql);
        List list = query.list();
        for (Object obj : list) {
            Map map = (Map)obj;
            JSONObject json = this.MapToJson(map);
            array.put((Object)json);
        }
        String result = array.toString();
        log.debug((Object)result);
        return result;
    }

    @POST
    @Path(value="hql2")
    public String executeHql2(String hql) {
        StringBuffer sb = new StringBuffer();
        hql = hql.replace("|", "/");
        log.debug((Object)hql);
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.createQuery(hql);
        List list = query.list();
        for (Object obj : list) {
            Map map = (Map)obj;
            JSONObject json = this.MapToJson(map);
            sb.append(json.toString() + "\r\n");
        }
        if (sb.length() == 0) {
            return "[]";
        }
        return sb.toString();
    }
}

