/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;

public class UnionUtils {
    protected static final String DEFAUTL_CHARTSET = "ISO-8859-1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key getKey(String storeType, String storePath, String keyTyep, String password) {
        Key pvtKey = null;
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            try {
                fileInputStream = new FileInputStream(storePath);
                keyStore.load(fileInputStream, password.toCharArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                fileInputStream.close();
            }
            pvtKey = keyStore.getKey(keyTyep, password.toCharArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pvtKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCertificate(String storeType, String storePath, String name, String password) {
        Certificate cert = null;
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType);
            try {
                fileInputStream = new FileInputStream(storePath);
                keyStore.load(fileInputStream, password.toCharArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                fileInputStream.close();
            }
            cert = keyStore.getCertificate(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return cert;
    }

    public static byte[] aschex_to_bcdhex(String aschex) {
        byte[] aschexByte = aschex.getBytes();
        int j = 0;
        if (aschexByte.length % 2 == 0) {
            j = aschexByte.length / 2;
            byte[] resTmp = new byte[j];
            for (int i = 0; i < j; ++i) {
                resTmp[i] = UnionUtils.ascToHex(aschexByte[2 * i], aschexByte[2 * i + 1]);
            }
            return resTmp;
        }
        j = aschexByte.length / 2 + 1;
        byte[] resTmp = new byte[j];
        for (int i = 0; i < j - 1; ++i) {
            resTmp[i] = UnionUtils.ascToHex(aschexByte[2 * i], aschexByte[2 * i + 1]);
        }
        resTmp[j - 1] = UnionUtils.ascToHex(aschexByte[2 * (j - 1)], (byte)0);
        return resTmp;
    }

    public static byte ascToHex(byte ch1, byte ch2) {
        byte ch = ch1 >= 65 ? (byte)(ch1 - 55 << 4) : (byte)(ch1 - 48 << 4);
        ch = ch2 >= 65 ? (byte)(ch | (byte)(ch2 - 55)) : (byte)(ch | (byte)(ch2 - 48));
        return ch;
    }

    public static byte hexLowToAsc(byte xxc) {
        xxc = (xxc = (byte)(xxc & 0xF)) < 10 ? (byte)(xxc + 48) : (byte)(xxc + 55);
        return xxc;
    }

    public static byte hexHighToAsc(int xxc) {
        xxc &= 0xF0;
        xxc = (xxc >>= 4) < 10 ? (xxc += 48) : (xxc += 55);
        return (byte)xxc;
    }

    public static byte[] toAsn1Len(int len) {
        int ret = 0;
        byte[] buff = new byte[10];
        byte[] asn1Len = null;
        if (len > 65535) {
            return null;
        }
        if (len > 255) {
            buff[0] = -126;
            buff[1] = (byte)((len & 0xFF00) >> 8);
            buff[2] = (byte)(len & 0xFF);
            ret = 3;
        } else if ((len & 0x80) != 0) {
            buff[0] = -127;
            buff[1] = (byte)len;
            ret = 2;
        } else {
            buff[0] = (byte)len;
            ret = 1;
        }
        asn1Len = new byte[ret];
        System.arraycopy(buff, 0, asn1Len, 0, ret);
        return asn1Len;
    }

    public static String bcdhex_to_aschex(byte[] bcdhex) {
        byte[] aschex = new byte[]{0, 0};
        String res = "";
        String tmp = "";
        for (int i = 0; i < bcdhex.length; ++i) {
            aschex[1] = UnionUtils.hexLowToAsc(bcdhex[i]);
            aschex[0] = UnionUtils.hexHighToAsc(bcdhex[i]);
            tmp = new String(aschex);
            res = res + tmp;
        }
        return res;
    }

    public static byte[] bcdhex_to_aschex(byte[] bcdhex, int len) {
        byte[] aschex = new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            aschex[2 * i] = UnionUtils.hexHighToAsc(bcdhex[i]);
            aschex[2 * i + 1] = UnionUtils.hexLowToAsc(bcdhex[i]);
        }
        return aschex;
    }

    public static byte[] aschex_to_bcdhex(byte[] aschex, int len) {
        int j = len % 2 == 0 ? len / 2 : len / 2 + 1;
        byte[] bcdhex = new byte[j];
        for (int i = 0; i < j; ++i) {
            bcdhex[i] = UnionUtils.ascToHex(aschex[2 * i], aschex[2 * i + 1]);
        }
        return bcdhex;
    }

    public static final String xor(String a, String b) {
        if (a.length() != b.length()) {
            return null;
        }
        byte[] aBuf = UnionUtils.aschex_to_bcdhex(a);
        byte[] bBuf = UnionUtils.aschex_to_bcdhex(b);
        byte[] outBuf = new byte[aBuf.length];
        for (int j = 0; j < aBuf.length; ++j) {
            outBuf[j] = (byte)(aBuf[j] ^ bBuf[j]);
        }
        return UnionUtils.bcdhex_to_aschex(outBuf);
    }

    public static String sha1String(String inStr) {
        MessageDigest md = null;
        String outStr = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] data = null;
            try {
                data = inStr.getBytes(DEFAUTL_CHARTSET);
            }
            catch (Exception e) {
                data = inStr.getBytes();
            }
            byte[] digest = md.digest(data);
            outStr = UnionUtils.bcdhex_to_aschex(digest);
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        return outStr;
    }

    public static String md5String(String inStr) {
        MessageDigest md = null;
        String outStr = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] data = null;
            try {
                data = inStr.getBytes(DEFAUTL_CHARTSET);
            }
            catch (Exception e) {
                data = inStr.getBytes();
            }
            byte[] digest = md.digest(data);
            outStr = UnionUtils.bcdhex_to_aschex(digest);
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        return outStr;
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
            if (n >= b.length - 1) continue;
            hs = hs + "";
        }
        return hs.toUpperCase();
    }

    public static byte[] hex2byte(String str) {
        int len = str.length();
        String stmp = null;
        byte[] bt = new byte[len / 2];
        for (int n = 0; n < len / 2; ++n) {
            stmp = str.substring(n * 2, n * 2 + 2);
            bt[n] = (byte)Integer.parseInt(stmp, 16);
        }
        return bt;
    }

    public static String paddingRightStr(String str, char padc, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        int numc = length - str.length();
        StringBuffer rets = new StringBuffer(str);
        for (int i = 0; i < numc; ++i) {
            rets.append(padc);
        }
        return rets.toString();
    }

    public static String paddingLeftStr(String str, char padc, int length) {
        if (str.length() > length) {
            return str.substring(0, length);
        }
        int numc = length - str.length();
        StringBuffer rets = new StringBuffer(str);
        for (int i = 0; i < numc; ++i) {
            rets.insert(0, padc);
        }
        return rets.toString();
    }

    public static byte[] addByteArray(byte[] bytes1, byte[] bytes2) {
        byte[] temp;
        if (bytes1 == null) {
            temp = new byte[bytes2.length];
            System.arraycopy(bytes2, 0, temp, 0, bytes2.length);
        } else if (bytes2 == null) {
            temp = new byte[bytes1.length];
            System.arraycopy(bytes1, 0, temp, 0, bytes1.length);
        } else {
            temp = new byte[bytes1.length + bytes2.length];
            System.arraycopy(bytes1, 0, temp, 0, bytes1.length);
            System.arraycopy(bytes2, 0, temp, bytes1.length, bytes2.length);
        }
        return temp;
    }
}

