/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Hex {
    private Hex() {
        throw new AssertionError((Object)"static class.");
    }

    public static String encode(String data) {
        return data == null ? "" : Hex.encode(data.getBytes());
    }

    public static String encode(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        byte[] hex = new byte[data.length * 2];
        byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        for (int i = 0; i < data.length; ++i) {
            hex[2 * i] = HEX[(data[i] & 0xFF) >> 4];
            hex[2 * i + 1] = HEX[data[i] & 0xF];
        }
        return new String(hex);
    }

    public static byte[] decode(String str) {
        if (str == null || str.length() == 0) {
            return new byte[0];
        }
        if (!Hex.isBase16String(str)) {
            throw new IllegalArgumentException(String.format("illegal Hex string[%s].", str));
        }
        byte[] hex = str.getBytes();
        byte[] bin = new byte[hex.length / 2];
        for (int i = 0; i < bin.length; ++i) {
            bin[i] = (byte)(((hex[2 * i] >> 6) * 9 + (hex[2 * i] & 0xF)) * 16 + (hex[2 * i + 1] >> 6) * 9 + (hex[2 * i + 1] & 0xF));
        }
        return bin;
    }

    private static boolean isBase16String(String str) {
        if (str.length() % 2 != 0) {
            return false;
        }
        String regex = "^[A-Fa-f0-9]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static String toHexString(byte[] bs) {
        return Hex.encode(bs);
    }

    public static String toHexString(byte[] bs, int start, int len) {
        byte[] bytes = new byte[len];
        System.arraycopy(bs, start, bytes, 0, len);
        return Hex.encode(bytes);
    }
}

