/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.math.ec.sec;

import io.soft.algorithm.math.ec.ECCurve;
import io.soft.algorithm.math.ec.ECFieldElement;
import io.soft.algorithm.math.ec.ECLookupTable;
import io.soft.algorithm.math.ec.ECPoint;
import io.soft.algorithm.math.ec.Nat256;
import io.soft.algorithm.math.ec.sec.SecT193FieldElement;
import io.soft.algorithm.math.ec.sec.SecT193R1Point;
import io.soft.algorithm.util.Hex;
import java.math.BigInteger;

public class SecT193R1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT193R1_DEFAULT_COORDS = 6;
    protected SecT193R1Point infinity = new SecT193R1Point(this, null, null);

    public SecT193R1Curve() {
        super(193, 15, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("0017858FEB7A98975169E171F77B4087DE098AC8A911DF7B01")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("00FDFB49BFE6C3A89FACADAA7A1E5BBC7CC1C2E5D831478814")));
        this.order = new BigInteger(1, Hex.decode("01000000000000000000000000C7F34A778F443ACC920EBA49"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT193R1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 193;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT193FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT193R1Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT193R1Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 193;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 15;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 4;
        final long[] table = new long[len * 4 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat256.copy64(((SecT193FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat256.copy64(((SecT193FieldElement)p.getRawYCoord()).x, 0, table, pos += 4);
            pos += 4;
        }
        return new ECLookupTable(){

            public int getSize() {
                return len;
            }

            public ECPoint lookup(int index) {
                long[] x = Nat256.create64();
                long[] y = Nat256.create64();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    long MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 4; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 4 + j] & MASK;
                    }
                    pos += 8;
                }
                return SecT193R1Curve.this.createRawPoint(new SecT193FieldElement(x), new SecT193FieldElement(y), false);
            }
        };
    }

    protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
        return null;
    }

    public ECPoint subtract(ECPoint b) {
        return null;
    }
}

