/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.math.ec.sec;

import io.soft.algorithm.math.ec.ECCurve;
import io.soft.algorithm.math.ec.ECFieldElement;
import io.soft.algorithm.math.ec.ECLookupTable;
import io.soft.algorithm.math.ec.ECPoint;
import io.soft.algorithm.math.ec.Nat128;
import io.soft.algorithm.math.ec.sec.SecT113FieldElement;
import io.soft.algorithm.math.ec.sec.SecT113R2Point;
import io.soft.algorithm.util.Hex;
import java.math.BigInteger;

public class SecT113R2Curve
extends ECCurve.AbstractF2m {
    private static final int SecT113R2_DEFAULT_COORDS = 6;
    protected SecT113R2Point infinity = new SecT113R2Point(this, null, null);

    public SecT113R2Curve() {
        super(113, 9, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("00689918DBEC7E5A0DD6DFC0AA55C7")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("0095E9A9EC9B297BD4BF36E059184F")));
        this.order = new BigInteger(1, Hex.decode("010000000000000108789B2496AF93"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
        return null;
    }

    protected ECCurve cloneCurve() {
        return new SecT113R2Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 113;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT113FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT113R2Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT113R2Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 113;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 9;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 2;
        final long[] table = new long[len * 2 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat128.copy64(((SecT113FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat128.copy64(((SecT113FieldElement)p.getRawYCoord()).x, 0, table, pos += 2);
            pos += 2;
        }
        return new ECLookupTable(){

            public int getSize() {
                return len;
            }

            public ECPoint lookup(int index) {
                long[] x = Nat128.create64();
                long[] y = Nat128.create64();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    long MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 2; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 2 + j] & MASK;
                    }
                    pos += 4;
                }
                return SecT113R2Curve.this.createRawPoint(new SecT113FieldElement(x), new SecT113FieldElement(y), false);
            }
        };
    }
}

