/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.jce;

import io.soft.algorithm.asn1.ASN1ObjectIdentifier;
import io.soft.algorithm.asn1.X9ECParameters;
import io.soft.algorithm.crypto.ec.CustomNamedCurves;
import io.soft.algorithm.jce.ECNamedCurveParameterSpec;
import java.util.Enumeration;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = CustomNamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = CustomNamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (ecP == null && (ecP = io.soft.algorithm.asn1.ECNamedCurveTable.getByName(name)) == null) {
                try {
                    ecP = io.soft.algorithm.asn1.ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(name));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return io.soft.algorithm.asn1.ECNamedCurveTable.getNames();
    }
}

