/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.jcajce.provider.asymmetric.rsa;

import io.soft.algorithm.asn1.ASN1Encodable;
import io.soft.algorithm.asn1.ASN1ObjectIdentifier;
import io.soft.algorithm.asn1.AlgorithmIdentifier;
import io.soft.algorithm.asn1.DERNull;
import io.soft.algorithm.asn1.PKCSObjectIdentifiers;
import io.soft.algorithm.asn1.RSAPrivateKey;
import io.soft.algorithm.crypto.params.RSAKeyParameters;
import io.soft.algorithm.jcajce.provider.asymmetric.util.KeyUtil;
import io.soft.algorithm.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import io.soft.algorithm.jce.interfaces.PKCS12BagAttributeCarrier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Enumeration;

public class BCRSAPrivateKey
implements java.security.interfaces.RSAPrivateKey,
PKCS12BagAttributeCarrier {
    static final long serialVersionUID = 5110188922551353628L;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    protected BigInteger modulus;
    protected BigInteger privateExponent;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected BCRSAPrivateKey() {
    }

    public BCRSAPrivateKey(RSAKeyParameters key) {
        this.modulus = key.getModulus();
        this.privateExponent = key.getExponent();
    }

    BCRSAPrivateKey(RSAPrivateKeySpec spec) {
        this.modulus = spec.getModulus();
        this.privateExponent = spec.getPrivateExponent();
    }

    BCRSAPrivateKey(java.security.interfaces.RSAPrivateKey key) {
        this.modulus = key.getModulus();
        this.privateExponent = key.getPrivateExponent();
    }

    BCRSAPrivateKey(RSAPrivateKey key) {
        this.modulus = key.getModulus();
        this.privateExponent = key.getPrivateExponent();
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        return KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(this.getModulus(), ZERO, this.getPrivateExponent(), ZERO, ZERO, ZERO, ZERO, ZERO));
    }

    public boolean equals(Object o) {
        if (!(o instanceof java.security.interfaces.RSAPrivateKey)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        java.security.interfaces.RSAPrivateKey key = (java.security.interfaces.RSAPrivateKey)o;
        return this.getModulus().equals(key.getModulus()) && this.getPrivateExponent().equals(key.getPrivateExponent());
    }

    public int hashCode() {
        return this.getModulus().hashCode() ^ this.getPrivateExponent().hashCode();
    }

    public void setBagAttribute(ASN1ObjectIdentifier oid, ASN1Encodable attribute) {
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier oid) {
        return this.attrCarrier.getBagAttribute(oid);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

