/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.jcajce.provider.asymmetric.ec;

import io.soft.algorithm.asn1.X9IntegerConverter;
import io.soft.algorithm.crypto.CipherParameters;
import io.soft.algorithm.crypto.DerivationFunction;
import io.soft.algorithm.crypto.agreement.BasicAgreement;
import io.soft.algorithm.crypto.agreement.ECDHBasicAgreement;
import io.soft.algorithm.crypto.agreement.ECDHCUnifiedAgreement;
import io.soft.algorithm.crypto.generator.KDF2BytesGenerator;
import io.soft.algorithm.crypto.params.AsymmetricKeyParameter;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.util.DigestFactory;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import io.soft.algorithm.jcajce.provider.asymmetric.util.ECUtil;
import io.soft.algorithm.jce.interfaces.ECPrivateKey;
import io.soft.algorithm.jce.interfaces.ECPublicKey;
import io.soft.algorithm.util.Arrays;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private Object agreement;
    public byte[] result;

    public KeyAgreementSpi(String kaAlgorithm, BasicAgreement agreement, DerivationFunction kdf) {
        super(kaAlgorithm, kdf);
        this.kaAlgorithm = kaAlgorithm;
        this.agreement = agreement;
    }

    public KeyAgreementSpi(String kaAlgorithm, ECDHCUnifiedAgreement agreement, DerivationFunction kdf) {
        super(kaAlgorithm, kdf);
        this.kaAlgorithm = kaAlgorithm;
        this.agreement = agreement;
    }

    public byte[] bigIntToBytes(BigInteger r) {
        return converter.integerToBytes(r, converter.getByteLength(this.parameters.getCurve()));
    }

    public Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException(this.kaAlgorithm + " not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(this.kaAlgorithm + " can only be between two parties.");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(ECPublicKey.class) + " for doPhase");
        }
        AsymmetricKeyParameter pubKey = ECUtil.generatePublicKeyParameter((PublicKey)key);
        try {
            if (this.agreement instanceof BasicAgreement) {
                this.result = this.bigIntToBytes(((BasicAgreement)this.agreement).calculateAgreement(pubKey));
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("calculation failed: " + e.getMessage()){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        return null;
    }

    public byte[] engineDoPhase(CipherParameters pubKey) throws AlgorithmCallingException {
        if (this.parameters == null) {
            throw new IllegalStateException(this.kaAlgorithm + " not initialised.");
        }
        try {
            if (this.agreement instanceof BasicAgreement) {
                this.result = this.bigIntToBytes(((BasicAgreement)this.agreement).calculateAgreement(pubKey));
            }
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("calculation failed: " + e.getCause().getMessage()){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        return this.result;
    }

    public void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        if (params != null) {
            throw new InvalidKeyException("No algorithm parameters supported");
        }
        this.initFromKey(key, params);
    }

    public void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.initFromKey(key, null);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    public void engineInit(ECPrivateKeyParameters ecPrivateKeyParameters, SecureRandom random) throws AlgorithmCallingException {
        try {
            this.initFromKey(ecPrivateKeyParameters);
        }
        catch (AlgorithmCallingException e) {
            throw new AlgorithmCallingException(e.getCause().getMessage());
        }
    }

    public void initFromKey(ECPrivateKeyParameters privKey) throws AlgorithmCallingException {
        this.parameters = privKey.getParameters();
        ((BasicAgreement)this.agreement).init(privKey);
    }

    public void initFromKey(Key key, AlgorithmParameterSpec parameterSpec) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(ECPrivateKey.class) + " for initialisation");
        }
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.parameters = privKey.getParameters();
        ((BasicAgreement)this.agreement).init(privKey);
    }

    private static String getSimpleName(Class clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public byte[] calcSecret() {
        return Arrays.clone(this.result);
    }

    public static class DHwithSHA512KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA512KDFAndSharedInfo() {
            super("ECDHwithSHA512KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHwithSHA384KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA384KDFAndSharedInfo() {
            super("ECDHwithSHA384KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHwithSHA256KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA256KDFAndSharedInfo() {
            super("ECDHwithSHA256KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHwithSHA224KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA224KDFAndSharedInfo() {
            super("ECDHwithSHA224KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class DHwithSHA1KDFAndSharedInfo
    extends KeyAgreementSpi {
        public DHwithSHA1KDFAndSharedInfo() {
            super("ECDHwithSHA1KDF", new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DH
    extends KeyAgreementSpi {
        public DH() {
            super("ECDH", new ECDHBasicAgreement(), null);
        }
    }
}

