/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.custom.gxnongxin;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.KeyPair;
import io.soft.algorithm.api.v1.KeyPairGenerator;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.api.v1.Signature;
import io.soft.algorithm.asn1.ASN1EncodableVector;
import io.soft.algorithm.asn1.ASN1InputStream;
import io.soft.algorithm.asn1.ASN1Integer;
import io.soft.algorithm.asn1.ASN1Sequence;
import io.soft.algorithm.asn1.DERSequence;
import io.soft.algorithm.crypto.params.AsymmetricCipherKeyPair;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECKeyGenerationParameters;
import io.soft.algorithm.crypto.params.ECKeyPairGenerator;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.params.ECPublicKeyParameters;
import io.soft.algorithm.custom.gxnongxin.KeyContainer;
import io.soft.algorithm.custom.gxnongxin.Streams;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.jce.ECNamedCurveParameterSpec;
import io.soft.algorithm.jce.ECNamedCurveTable;
import io.soft.algorithm.math.ec.ECCurve;
import io.soft.algorithm.math.ec.ECPoint;
import io.soft.algorithm.util.Checker;
import io.soft.algorithm.util.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionFileEncAPI {
    public Map<String, byte[]> CMBSM2KeyGen() {
        ECDomainParameters domainParameters = this.getECDomainParameters();
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters parameters = new ECKeyGenerationParameters(domainParameters, new SecureRandom());
        generator.init(parameters);
        AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
        ECPublicKeyParameters publicKeyParameters = (ECPublicKeyParameters)keyPair.getPublic();
        ECPrivateKeyParameters privateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("publickey", publicKeyParameters.getQ().getEncoded(false));
        map.put("privatekey", this.format(privateKeyParameters.getD().toByteArray()));
        return map;
    }

    public KeyContainer unionGenerateKey(int algFlag, int keyLen, String pkExponent) {
        KeyContainer key = new KeyContainer();
        if (algFlag != 1) {
            key.setSuccess(0);
            return key;
        }
        KeyPairGenerator generator = KeyPairGenerator.getSM2();
        KeyPair keyPair = generator.generator();
        key.setPkValue(keyPair.getPublicKey());
        key.setVkValue(keyPair.getPrivateKey());
        key.setSuccess(1);
        return key;
    }

    public int unionEncryptFile(String plainFile, String cipherFile, int keyMode, String keyType, String keyValue, int paddingFlag, int algorithmID, String iv) {
        BufferedInputStream inputStream = null;
        FilterOutputStream outputStream = null;
        String algID = "";
        String tmpData = "";
        if (plainFile == null || "".equals(plainFile)) {
            System.out.println("plainFile\u4e3a\u7a7a");
            return -1;
        }
        if (cipherFile == null || "".equals(cipherFile)) {
            System.out.println("cipherFile\u4e3a\u7a7a");
            return -1;
        }
        if (keyType == null || "".equals(keyType)) {
            System.out.println("keyType\u4e0d\u80fd\u4e3a\u7a7a");
            return -1;
        }
        if (!keyType.equals("S")) {
            System.out.println("keyType\u53ea\u80fd\u4e3aS");
            return -1;
        }
        algID = "SM4";
        if (keyMode != 0) {
            if (keyMode == 2) {
                if (keyValue == null || "".equals(keyValue)) {
                    System.out.println("keyMode=2\u65f6keyValue\u4e3a\u7a7a");
                    return -1;
                }
            } else {
                System.out.println("keyMode\u5fc5\u987b\u4e3a2");
                return -1;
            }
        }
        if (paddingFlag != 0 && paddingFlag != 1) {
            System.out.println("paddingFlag\u5fc5\u987b\u4e3a0\u62161");
            return -1;
        }
        if (algorithmID != 0 && algorithmID != 1) {
            System.out.println("algorithmID\u5fc5\u987b\u4e3a0\u6216\u80051");
            return -1;
        }
        if (algorithmID == 1 && (keyType.equals("S") || keyMode == 4) && (iv == null || "".equals(iv))) {
            iv = "00000000000000000000000000000000";
        }
        Padding padding = null;
        Mode mode = null;
        try {
            int i;
            inputStream = new BufferedInputStream(new FileInputStream(plainFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(cipherFile, false));
            byte[] buffer = Streams.readFully(inputStream);
            tmpData = Hex.encode(buffer);
            int len = tmpData.length();
            int perLen = 4096;
            int num = len / perLen;
            int mlen = len % perLen;
            if (mlen != 0) {
                ++num;
            }
            String[] ptr = new String[num];
            int tmpPaddingFlag = 0;
            String m_iv = iv;
            for (i = 0; i < num; ++i) {
                ptr[i] = i == num - 1 && mlen != 0 ? tmpData.substring(i * perLen, i * perLen + mlen) : tmpData.substring(i * perLen, (i + 1) * perLen);
            }
            for (i = 0; i < num; ++i) {
                if (paddingFlag != 0) {
                    tmpPaddingFlag = i == num - 1 ? paddingFlag : 0;
                }
                try {
                    padding = tmpPaddingFlag == 1 && keyType.equals("S") ? Padding.PKCS7Padding : Padding.NoPadding;
                    mode = algorithmID == 0 ? Mode.ECB : Mode.CBC;
                    Cipher cipher = null;
                    String key = null;
                    cipher = Cipher.getInstance(Algorithm.SM4, mode, padding);
                    if (mode == Mode.CBC) {
                        cipher.setIv(Hex.decode(m_iv));
                    }
                    if (keyMode == 0) {
                        byte[] bytes = new byte[16];
                        try {
                            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                            random.nextBytes(bytes);
                            key = Hex.encode(bytes);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new AlgorithmCallingException("Generate random key failed.", e);
                        }
                    } else if (keyMode == 2) {
                        key = keyValue;
                    }
                    byte[] ciphertext = cipher.encrypt(Hex.decode(key), ptr[i].getBytes());
                    String buf = Hex.encode(ciphertext);
                    m_iv = buf.substring(buf.length() - 32);
                    outputStream.write(buf.getBytes());
                    continue;
                }
                catch (IOException e) {
                    throw new AlgorithmCallingException(e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    public int unionDecryptFile(String cipherFile, String plainFile, String keyValue, String keyType, int paddingFlag, int algorithmID, String iv) {
        BufferedInputStream inputStream = null;
        FilterOutputStream outputStream = null;
        String tmpData = "";
        if (plainFile == null || "".equals(plainFile)) {
            System.out.println("plainFile\u4e3a\u7a7a");
            return -1;
        }
        if (cipherFile == null || "".equals(cipherFile)) {
            System.out.println("cipherFile\u4e3a\u7a7a");
            return -1;
        }
        if (keyValue == null || "".equals(keyValue)) {
            System.out.println("keyValue\u4e3a\u7a7a");
            return -1;
        }
        if (paddingFlag != 0 && paddingFlag != 1) {
            System.out.println("paddingFlag\u5fc5\u987b\u4e3a0\u62161");
            return -1;
        }
        if (algorithmID != 0 && algorithmID != 1) {
            System.out.println("algorithmID \u5fc5\u987b\u4e3a0 \u6216\u8005 1");
            return -1;
        }
        if (algorithmID == 1 && (iv == null || "".equals(iv))) {
            iv = "00000000000000000000000000000000";
        }
        Padding padding = null;
        Mode mode = null;
        String algID = "";
        if (keyType == null || "".equals(keyType)) {
            System.out.println("keyType\u4e0d\u80fd\u4e3a\u7a7a");
            return -1;
        }
        if (!keyType.equals("S")) {
            System.out.println("keyType\u53ea\u80fd\u4e3aS");
            return -1;
        }
        algID = "SM4";
        try {
            int i;
            inputStream = new BufferedInputStream(new FileInputStream(cipherFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(plainFile, false));
            byte[] buffer = Streams.readFully(inputStream);
            tmpData = new String(buffer);
            int len = tmpData.length();
            int perLen = 4096;
            int num = len / perLen;
            int mlen = len % perLen;
            int tmpPaddingFlag = 0;
            String m_iv = iv;
            if (mlen != 0) {
                ++num;
            }
            String[] ptr = new String[num];
            for (i = 0; i < num; ++i) {
                ptr[i] = i == num - 1 && mlen != 0 ? tmpData.substring(i * perLen, i * perLen + mlen) : tmpData.substring(i * perLen, (i + 1) * perLen);
            }
            for (i = 0; i < num; ++i) {
                if (paddingFlag != 0) {
                    tmpPaddingFlag = i == num - 1 ? paddingFlag : 0;
                }
                padding = tmpPaddingFlag == 1 && keyType.equals("S") ? Padding.PKCS7Padding : Padding.NoPadding;
                mode = algorithmID == 0 ? Mode.ECB : Mode.CBC;
                Cipher cipher = null;
                if ("SM4".equals(algID)) {
                    cipher = Cipher.getInstance(Algorithm.SM4, mode, padding);
                }
                if (algorithmID != 0) {
                    cipher.setIv(Hex.decode(m_iv));
                }
                byte[] ciphertext = cipher.decrypt(Hex.decode(keyValue), Hex.decode(ptr[i]));
                String s = new String(ciphertext);
                byte[] ret = new String(Hex.decode(s)).getBytes();
                m_iv = ptr[i].substring(ptr[i].length() - 32);
                outputStream.write(ret);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    private ECCurve getSM2Curve() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec("sm2p256v1");
        return spec.getCurve();
    }

    private ECDomainParameters getECDomainParameters() {
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec("sm2p256v1");
        return new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
    }

    private ECPublicKeyParameters encodePublicKey(byte[] value) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(value, 1, x, 0, 32);
        System.arraycopy(value, 33, y, 0, 32);
        BigInteger X = new BigInteger(1, x);
        BigInteger Y = new BigInteger(1, y);
        ECPoint Q = this.getSM2Curve().createPoint(X, Y);
        return new ECPublicKeyParameters(Q, this.getECDomainParameters());
    }

    private byte[] C1C2C3ToC1C3C2(byte[] cipherText) throws AlgorithmCallingException {
        if (cipherText == null || cipherText.length < 97) {
            throw new AlgorithmCallingException("Illegal Argument: SM2 cipher text error, must be more than 96 bytes and in the format: C1||C3||C2.");
        }
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 65);
        System.arraycopy(cipherText, cipherText.length - 32, bytes, 65, 32);
        System.arraycopy(cipherText, 65, bytes, 97, cipherText.length - 97);
        return bytes;
    }

    private byte[] format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }

    private byte[] decodeDERSignature(byte[] signature) throws AlgorithmCallingException {
        ASN1InputStream stream = new ASN1InputStream(new ByteArrayInputStream(signature));
        try {
            ASN1Sequence primitive = (ASN1Sequence)stream.readObject();
            Enumeration enumeration = primitive.getObjects();
            BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
            BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
            byte[] bytes = new byte[64];
            byte[] r = this.format(R.toByteArray());
            byte[] s = this.format(S.toByteArray());
            System.arraycopy(r, 0, bytes, 0, 32);
            System.arraycopy(s, 0, bytes, 32, 32);
            return bytes;
        }
        catch (Exception e) {
            throw new AlgorithmCallingException("DER encoded data encoding or decoding error.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int unionEncryptAndSignFileWithKeyByPK(String plainFile, String cipherFile, byte[] signVkValue, byte[] encryptPkValue, int algFlag, int keyMode, String keyType, String keyValue, String signFlag, String userID, String hashID, String separator, int paddingFlag, int algorithmID, String iv) throws AlgorithmCallingException {
        BufferedInputStream inputStream = null;
        FilterOutputStream outputStream = null;
        String tmpData = "";
        try {
            int i;
            if (plainFile == null || "".equals(plainFile)) {
                System.out.println("plainFile\u4e3a\u7a7a");
                int n = -1;
                return n;
            }
            if (separator == null || "".equals(separator)) {
                separator = "|";
            }
            if (cipherFile == null || "".equals(cipherFile)) {
                System.out.println("cipherFile\u4e3a\u7a7a");
                int n = -1;
                return n;
            }
            if (encryptPkValue == null || "".equals(encryptPkValue)) {
                System.out.println("encryptPkValue\u4e3a\u7a7a");
                int n = -1;
                return n;
            }
            if (algFlag != 1) {
                System.out.println("algFlag\u5fc5\u987b\u4e3a1");
                int n = -1;
                return n;
            }
            if (keyMode != 0 && keyMode != 2) {
                System.out.println("keyMode\u5fc5\u987b\u4e3a0\u62162");
                int n = -1;
                return n;
            }
            if (keyType == null || "".equals(keyType)) {
                System.out.println("keyType\u4e3a\u7a7a");
                int n = -1;
                return n;
            }
            if (!"S".equals(keyType)) {
                System.out.println("keyType\u5fc5\u987b\u4e3aS");
                int n = -1;
                return n;
            }
            if (algFlag != 1) {
                System.out.println("\u4e0d\u652f\u6301\u8de8\u7b97\u6cd5\u52a0\u89e3\u5bc6");
                int n = -1;
                return n;
            }
            Algorithm algID = Algorithm.SM4;
            if (keyMode == 2 && (keyValue == null || "".equals(keyValue))) {
                System.out.println("keyValue\u4e3a\u7a7a");
                int n = -1;
                return n;
            }
            if (signFlag.equals("Y")) {
                if (signVkValue == null || "".equals(signVkValue)) {
                    System.out.println("signVkValue\u4e3a\u7a7a");
                    int n = -1;
                    return n;
                }
                if (userID == null || "".equals(userID)) {
                    userID = "1234567812345678";
                }
            }
            String key = "";
            if (keyMode == 0) {
                byte[] bytes = new byte[16];
                try {
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    random.nextBytes(bytes);
                    key = Hex.encode(bytes);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AlgorithmCallingException("Generate random key failed.", e);
                }
            } else {
                key = keyValue;
            }
            byte[] keyByPk = "".getBytes();
            if (algFlag == 1) {
                Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
                keyByPk = cipher.encrypt(encryptPkValue, Hex.decode(key));
            }
            if (paddingFlag != 0 && paddingFlag != 1) {
                System.out.println("paddingFlag\u5fc5\u987b\u4e3a0\u62161");
                int cipher = -1;
                return cipher;
            }
            if (algorithmID != 0 && algorithmID != 1) {
                System.out.println("algorithmID\u5fc5\u987b\u4e3a0\u6216\u80051");
                int cipher = -1;
                return cipher;
            }
            if (algorithmID == 1 && keyType.equals("S") && (iv == null || "".equals(iv))) {
                iv = "00000000000000000000000000000000";
            }
            inputStream = new BufferedInputStream(new FileInputStream(plainFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(cipherFile, false));
            byte[] buffer = Streams.readFully(inputStream);
            tmpData = Hex.encode(buffer);
            byte[] sign = "".getBytes();
            if (signFlag.equals("Y")) {
                if (!hashID.equals("03")) {
                    System.out.println("hashID\u5fc5\u987b\u4e3a03");
                    int n = -1;
                    return n;
                }
                Algorithm hashId = Algorithm.SM3;
                if (algFlag == 1) {
                    Signature signature = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
                    signature.setUserID(userID.getBytes());
                    sign = signature.sign(signVkValue, buffer);
                }
                outputStream.write(Hex.encode(sign).getBytes());
                outputStream.write(separator.getBytes());
            }
            String tmpKeyByPk = Hex.encode(keyByPk);
            outputStream.write(tmpKeyByPk.getBytes());
            outputStream.write(separator.getBytes());
            Cipher cipher = null;
            int tmpPaddingFlag = 0;
            int len = tmpData.length();
            int perLen = 4096;
            int num = len / perLen;
            int mlen = len % perLen;
            String m_iv = iv;
            if (mlen != 0) {
                ++num;
            }
            String[] ptr = new String[num];
            for (i = 0; i < num; ++i) {
                ptr[i] = i == num - 1 && mlen != 0 ? tmpData.substring(i * perLen, i * perLen + mlen) : tmpData.substring(i * perLen, (i + 1) * perLen);
            }
            i = 0;
            while (i < num) {
                if (paddingFlag != 0) {
                    tmpPaddingFlag = i == num - 1 ? paddingFlag : 0;
                }
                Padding padding = tmpPaddingFlag == 1 && keyType.equals("S") ? Padding.PKCS7Padding : Padding.NoPadding;
                Mode mode = algorithmID == 0 ? Mode.ECB : Mode.CBC;
                cipher = Cipher.getInstance(algID, mode, padding);
                if (mode == Mode.CBC) {
                    cipher.setIv(Hex.decode(m_iv));
                }
                byte[] ciphertext = cipher.encrypt(Hex.decode(key), Hex.decode(ptr[i]));
                String buf = Hex.encode(ciphertext);
                m_iv = buf.substring(buf.length() - 32);
                outputStream.write(buf.getBytes());
                ++i;
            }
            return -1;
        }
        catch (IOException e) {
            throw new AlgorithmCallingException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private byte[] C1C3C2ToC1C2C3(byte[] cipherText) throws AlgorithmCallingException {
        if (cipherText == null || cipherText.length < 97) {
            throw new AlgorithmCallingException("Illegal Argument: SM2 cipher text error, must be more than 96 bytes and in the format C1||C3||C2.");
        }
        byte[] bytes = new byte[cipherText.length];
        System.arraycopy(cipherText, 0, bytes, 0, 65);
        System.arraycopy(cipherText, 97, bytes, 65, cipherText.length - 97);
        System.arraycopy(cipherText, 65, bytes, cipherText.length - 32, 32);
        return bytes;
    }

    public byte[] CMBSM2Decrypt(byte[] privkey, byte[] msg) throws AlgorithmCallingException {
        msg = this.C1C3C2ToC1C2C3(msg);
        Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
        return cipher.decrypt(privkey, msg);
    }

    private byte[] encodeDERSignature(byte[] signature) throws AlgorithmCallingException {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(new ASN1Integer(new BigInteger(1, r)));
        vector.add(new ASN1Integer(new BigInteger(1, s)));
        try {
            return new DERSequence(vector).getEncoded();
        }
        catch (IOException e) {
            throw new AlgorithmCallingException("DER encoded data encoding or decoding error.", e);
        }
    }

    public boolean CMBSM2VerifyWithSM3(byte[] pubkey, byte[] msg, byte[] signature, byte[] userID) throws AlgorithmCallingException {
        Signature signature1 = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        signature1.setUserID(userID);
        boolean isTrue = signature1.verify(pubkey, msg, this.encodeDERSignature(signature));
        Checker.check(isTrue, "It\u2019s just a failure to check, not an exception.", new Object[0]);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int unionDecryptAndSignFileWithKeyByPK(String cipherFile, String plainFile, String verifySignFlag, byte[] signPkValue, byte[] encryptVkValue, int algFlag, String userID, String hashID, String separator, int paddingFlag, int algorithmID, String iv) throws AlgorithmCallingException {
        FilterOutputStream plainStream = null;
        BufferedInputStream cipherStream = null;
        BufferedInputStream inputStream = null;
        String keyByPK = "";
        byte[] keyValue = "".getBytes();
        String sign = "";
        String keyType = "";
        byte[] buffer = "".getBytes();
        if (cipherFile == null || "".equals(cipherFile)) {
            System.out.println("cipherFile\u4e3a\u7a7a");
            return -1;
        }
        if (separator == null || "".equals(separator)) {
            separator = "|";
        }
        if (plainFile == null || "".equals(plainFile)) {
            System.out.println("plainFile\u4e3a\u7a7a");
            return -1;
        }
        if (verifySignFlag.equals("Y") && (signPkValue == null || "".equals(signPkValue))) {
            System.out.println("signPkValue\u4e3a\u7a7a");
            return -1;
        }
        if (encryptVkValue == null || "".equals(encryptVkValue)) {
            System.out.println("encryptVkValue\u4e3a\u7a7a");
            return -1;
        }
        if (separator == null || "".equals(separator)) {
            separator = "|";
        }
        if (verifySignFlag.equals("Y") && (userID == null || "".equals(userID))) {
            userID = "1234567812345678";
        }
        if (paddingFlag != 0 && paddingFlag != 1) {
            System.out.println("paddingFlag\u5fc5\u987b\u4e3a0\u62161");
            return -1;
        }
        if (algFlag != 1) {
            System.out.println("algFlag\u5fc5\u987b\u662f1");
        }
        keyType = "S";
        if (algorithmID != 0 && algorithmID != 1) {
            System.out.println("algorithmID\u5fc5\u987b\u4e3a0\u6216\u80051");
            return -1;
        }
        if (algorithmID == 1 && keyType.equals("S") && (iv == null || "".equals(iv))) {
            iv = "00000000000000000000000000000000";
        }
        Algorithm algID = Algorithm.SM4;
        try {
            int i;
            plainStream = new BufferedOutputStream(new FileOutputStream(plainFile, false));
            cipherStream = new BufferedInputStream(new FileInputStream(cipherFile));
            byte[] cipherBuffer = Streams.readFully(cipherStream);
            String cipherData = new String(cipherBuffer);
            String symbol = "\\";
            String sep = symbol + separator;
            String[] splitData = cipherData.split(sep);
            if (verifySignFlag.equals("Y")) {
                if (splitData.length != 3) {
                    System.out.println("\u5bc6\u6587\u6587\u4ef6\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9");
                    int n = -1;
                    return n;
                }
                sign = splitData[0];
                keyByPK = splitData[1];
                cipherData = splitData[2];
            } else {
                if (splitData.length != 2) {
                    System.out.println("\u5bc6\u6587\u6587\u4ef6\u6570\u636e\u683c\u5f0f\u4e0d\u5bf9");
                    int n = -1;
                    return n;
                }
                keyByPK = splitData[0];
                cipherData = splitData[1];
            }
            Cipher cipher2 = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
            keyValue = cipher2.decrypt(encryptVkValue, Hex.decode(keyByPK));
            int length = cipherData.length();
            int perLen = 4096;
            int num = length / perLen;
            int mlen = length % perLen;
            int tmpPaddingFlag = 0;
            if (mlen != 0) {
                ++num;
            }
            String m_iv = iv;
            String[] ptr = new String[num];
            for (i = 0; i < num; ++i) {
                ptr[i] = i == num - 1 && mlen != 0 ? cipherData.substring(i * perLen, i * perLen + mlen) : cipherData.substring(i * perLen, (i + 1) * perLen);
            }
            for (i = 0; i < num; ++i) {
                if (paddingFlag != 0) {
                    tmpPaddingFlag = i == num - 1 ? paddingFlag : 0;
                }
                Padding padding = tmpPaddingFlag == 1 && keyType.equals("S") ? Padding.PKCS7Padding : Padding.NoPadding;
                Mode mode = algorithmID == 0 ? Mode.ECB : Mode.CBC;
                Cipher cipher = Cipher.getInstance(algID, mode, padding);
                if (mode == Mode.CBC) {
                    cipher.setIv(Hex.decode(m_iv));
                }
                byte[] plaintext = cipher.decrypt(keyValue, Hex.decode(ptr[i]));
                m_iv = ptr[i].substring(ptr[i].length() - 32);
                plainStream.write(plaintext);
            }
            plainStream.close();
            inputStream = new BufferedInputStream(new FileInputStream(plainFile));
            buffer = Streams.readFully(inputStream);
            if (!verifySignFlag.equals("Y")) return -1;
            if (!hashID.equals("03")) {
                System.out.println("hashID\u5fc5\u987b\u4e3a03\u6216\u8005\u4e3a\u7a7a");
                int plaintext = -1;
                return plaintext;
            }
            Algorithm algorithm = Algorithm.SM3;
            boolean result = false;
            if (algFlag == 1) {
                Signature signature = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
                signature.setUserID(userID.getBytes());
                result = signature.verify(signPkValue, buffer, Hex.decode(sign));
            }
            if (result) return -1;
            System.out.println("\u9a8c\u7b7e\u5931\u8d25");
            int n = -1;
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (plainStream != null) {
                try {
                    plainStream.close();
                }
                catch (IOException iOException) {}
            }
            if (cipherStream != null) {
                try {
                    cipherStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ECPrivateKeyParameters encodePrivateKey(byte[] value) {
        BigInteger d = new BigInteger(1, value);
        return new ECPrivateKeyParameters(d, this.getECDomainParameters());
    }

    public byte[] CMBSM2SignWithSM3(byte[] privkey, byte[] msg, byte[] userID) throws AlgorithmCallingException {
        if (privkey == null) {
            throw new AlgorithmCallingException("Illegal Argument: cannot be NULL.");
        }
        if (msg == null) {
            throw new AlgorithmCallingException("Illegal Argument: cannot be NULL.");
        }
        if (msg.length == 0) {
            throw new AlgorithmCallingException("Illegal Argument: The size of msg too small.");
        }
        if (privkey.length != 32) {
            throw new AlgorithmCallingException("Illegal Argument: SM2 private key error, must be 32 bytes.");
        }
        Signature signature = Signature.getInstance(Algorithm.SM2, Algorithm.NONE);
        signature.setUserID(userID);
        byte[] result = signature.sign(privkey, msg);
        return result;
    }
}

