/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.custom.gxnongxin;

import io.soft.algorithm.api.Padding;
import io.soft.algorithm.api.SM2;
import io.soft.algorithm.api.v1.Algorithm;
import io.soft.algorithm.api.v1.Cipher;
import io.soft.algorithm.api.v1.Mode;
import io.soft.algorithm.custom.gxnongxin.EnvelopeContainer;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;
import io.soft.algorithm.util.Hex;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class AlgorithmAPI {
    public String unionSign(int algFlag, byte[] signVkValue, String hashID, String userID, byte[] data) {
        if (algFlag != 1) {
            System.out.println("algorithm flag must be 1.");
            return null;
        }
        Checker.check(hashID == null || "03".equals(hashID) || hashID.length() == 0, "the hash id for sm2 signature can not be " + hashID, new Object[0]);
        SM2 sm2 = SM2.newInstance(null, signVkValue);
        if (userID == null || userID.length() == 0) {
            return Hex.encode(sm2.sign(data));
        }
        return Hex.encode(sm2.sign(data, userID.getBytes()));
    }

    public boolean unionVerifySign(int algFlag, byte[] verifySignPkValue, String hashID, String userID, byte[] data, String sign) {
        if (algFlag != 1) {
            System.out.println("algorithm flag must be 1.");
            return false;
        }
        Checker.check(hashID == null || "03".equals(hashID) || hashID.length() == 0, "the hash id for sm2 signature can not be " + hashID, new Object[0]);
        SM2 sm2 = SM2.newInstance(verifySignPkValue, null);
        if (userID == null || userID.length() == 0) {
            return sm2.verify(Hex.decode(sign), data);
        }
        return sm2.verify(Hex.decode(sign), data, userID.getBytes());
    }

    public EnvelopeContainer unionEncDataWithByEnv(int algFlag, String pkValue, int keyMode, String keyType, String keyValue, byte[] data, int dataType, String separator, int paddingFlag, int algorithmID, String iv) {
        if (algFlag != 1) {
            System.out.println("algFlag\u5fc5\u987b\u4e3a1");
            return null;
        }
        if (keyMode != 0 && keyMode != 2) {
            System.out.println("keyMode\u5fc5\u987b\u4e3a0\u62162");
            return null;
        }
        if (keyType == null || "".equals(keyType)) {
            System.out.println("keyType\u4e3a\u7a7a");
            return null;
        }
        if (!"S".equals(keyType)) {
            System.out.println("keyType\u5fc5\u987b\u4e3aS");
            return null;
        }
        Algorithm algID = Algorithm.SM4;
        if (keyMode == 2 && (keyValue == null || "".equals(keyValue))) {
            System.out.println("keyValue\u4e3a\u7a7a");
            return null;
        }
        if (algorithmID != 0 && algorithmID != 1) {
            System.out.println("algorithmID\u5fc5\u987b\u4e3a0\u6216\u52191");
            return null;
        }
        String key = "";
        if (keyMode == 0) {
            byte[] bytes = new byte[16];
            try {
                SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                random.nextBytes(bytes);
                key = Hex.encode(bytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AlgorithmCallingException("Generate random key failed.", e);
            }
        } else {
            key = keyValue;
        }
        byte[] keyByPk = "".getBytes();
        if (algFlag == 1) {
            byte[] publicKeyValue = Hex.decode(pkValue);
            Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
            keyByPk = cipher.encrypt(publicKeyValue, Hex.decode(key));
        }
        EnvelopeContainer envelopeContainer = new EnvelopeContainer();
        envelopeContainer.setKeyCipher(Hex.encode(keyByPk));
        if (paddingFlag != 0 && paddingFlag != 1) {
            System.out.println("paddingFlag\u5fc5\u987b\u4e3a0\u62161");
            return null;
        }
        Padding padding = paddingFlag == 0 ? Padding.NoPadding : Padding.PKCS5Padding;
        Mode mode = algorithmID == 0 ? Mode.ECB : Mode.CBC;
        if (algorithmID == 1 && (keyType.equals("S") || keyMode == 3) && (iv == null || "".equals(iv))) {
            iv = "00000000000000000000000000000000";
        }
        String[] str = null;
        if (separator != null && separator.length() != 0) {
            String req = "\\" + separator;
            if (dataType != 0 && dataType != 1) {
                System.out.println("dataType \u5fc5\u987b\u4e3a0\u6216\u80051");
                return null;
            }
            str = dataType == 1 ? new String(data).split(req) : new String(data).split(req);
        }
        String ret = "";
        Cipher cipher = Cipher.getInstance(algID, mode, padding);
        if (mode == Mode.CBC) {
            cipher.setIv(Hex.decode(iv));
        }
        if (separator != null && separator.length() != 0) {
            for (int i = 0; i < str.length; ++i) {
                if (dataType == 1) {
                    ret = ret + Hex.encode(cipher.encrypt(Hex.decode(key), Hex.decode(str[i])));
                    if (i >= str.length - 1) continue;
                    ret = ret + separator;
                    continue;
                }
                ret = ret + Hex.encode(cipher.encrypt(Hex.decode(key), str[i].getBytes()));
                if (i >= str.length - 1) continue;
                ret = ret + separator;
            }
        } else {
            ret = Hex.encode(cipher.encrypt(Hex.decode(key), data));
        }
        envelopeContainer.setDataCipher(ret);
        return envelopeContainer;
    }

    public String unionDecDataWithByEnv(int algFlag, String encryptVkValue, String keyBy, String encryptData, String separator, int paddingFlag, int exportFlag, int algorithmID, String iv) {
        if (algFlag != 1) {
            System.out.println("algorithm flag must be 1.");
            return null;
        }
        if (exportFlag != 0 && exportFlag != 1) {
            System.out.println("export flag must be 0 or 1.");
            return null;
        }
        if (algorithmID != 0 && algorithmID != 1) {
            System.out.println("algorithmID\u5fc5\u987b\u4e3a0\u6216\u52191");
            return null;
        }
        Algorithm algID = null;
        String keyType = "";
        if (algFlag == 1) {
            keyType = "S";
            algID = Algorithm.SM4;
        }
        byte[] key = null;
        if (algFlag == 1) {
            byte[] publicKeyValue = Hex.decode(encryptVkValue);
            Cipher cipher = Cipher.getInstance(Algorithm.SM2, Mode.NONE, Padding.NoPadding);
            key = cipher.decrypt(publicKeyValue, Hex.decode(keyBy));
        }
        if (paddingFlag != 0 && paddingFlag != 1) {
            System.out.println("paddingFlag\u5fc5\u987b\u4e3a0\u62161");
            return null;
        }
        Padding padding = paddingFlag == 0 ? Padding.NoPadding : Padding.PKCS5Padding;
        Mode mode = algorithmID == 0 ? Mode.ECB : Mode.CBC;
        if (algorithmID == 1 && keyType.equals("S") && (iv == null || "".equals(iv))) {
            iv = "00000000000000000000000000000000";
        }
        Cipher cipher = Cipher.getInstance(algID, mode, padding);
        if (mode == Mode.CBC) {
            cipher.setIv(Hex.decode(iv));
        }
        String[] str = null;
        if (separator != null && separator.length() != 0) {
            String req = "\\" + separator;
            str = encryptData.split(req);
        }
        String ret = "";
        if (separator != null && separator.length() != 0) {
            for (int i = 0; i < str.length; ++i) {
                if (exportFlag == 0) {
                    ret = ret + new String(cipher.decrypt(key, Hex.decode(str[i])));
                    if (i >= str.length - 1) continue;
                    ret = ret + separator;
                    continue;
                }
                if (exportFlag != 1) continue;
                ret = ret + Hex.encode(cipher.decrypt(key, Hex.decode(str[i])));
                if (i >= str.length - 1) continue;
                ret = ret + separator;
            }
        } else if (exportFlag == 0) {
            ret = new String(cipher.decrypt(key, Hex.decode(encryptData)));
        } else if (exportFlag == 1) {
            ret = Hex.encode(cipher.decrypt(key, Hex.decode(encryptData)));
        }
        return ret;
    }
}

