/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.symmetric;

public final class SM4Algorithm {
    static final int SM4_KEY_SIZE = 16;
    private int[] workingKey = null;
    private byte[] iv = null;
    private Mode mode = null;
    private boolean encryption;
    static final byte[] Sbox = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    static final int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
    static final int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};

    public void initWithECB(boolean encryption, byte[] key) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        this.workingKey = this.generateWorkingKey(encryption, key);
        this.mode = Mode.ECB;
    }

    public void initWithCBC(boolean encryption, byte[] key, byte[] iv) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        this.iv = iv;
        this.workingKey = this.generateWorkingKey(encryption, key);
        this.mode = Mode.CBC;
        this.encryption = encryption;
    }

    public void initWithOFB(boolean encryption, byte[] key, byte[] iv) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        this.iv = iv;
        this.workingKey = this.generateWorkingKey(true, key);
        this.mode = Mode.OFB;
        this.encryption = encryption;
    }

    public void initWithCFB(boolean encryption, byte[] key, byte[] iv) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        this.iv = iv;
        this.workingKey = this.generateWorkingKey(true, key);
        this.mode = Mode.CFB;
        this.encryption = encryption;
    }

    public void initWithCTR(boolean encryption, byte[] key, byte[] iv) {
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        if (iv == null || iv.length != 16) {
            throw new IllegalArgumentException(String.valueOf("the length of the key must be 16 bytes."));
        }
        this.iv = iv;
        this.workingKey = this.generateWorkingKey(true, key);
        this.mode = Mode.CTR;
        this.encryption = encryption;
    }

    public void init(boolean encryption, String mode, byte[] key, byte[] iv) {
        if ("ECB".equalsIgnoreCase(mode)) {
            this.initWithECB(encryption, key);
        } else if ("CBC".equalsIgnoreCase(mode)) {
            this.initWithCBC(encryption, key, iv);
        } else if ("CFB".equalsIgnoreCase(mode)) {
            this.initWithCFB(encryption, key, iv);
        } else if ("OFB".equalsIgnoreCase(mode)) {
            this.initWithOFB(encryption, key, iv);
        } else if ("CTR".equalsIgnoreCase(mode)) {
            this.initWithCTR(encryption, key, iv);
        } else {
            throw new IllegalArgumentException("unsupport encrypt/decrypt mode [ " + mode + " ].");
        }
    }

    public byte[] doFinal(byte[] data) {
        if (data == null || data.length % 16 != 0) {
            throw new IllegalArgumentException(String.valueOf("the length of the data must be a multiple of 16."));
        }
        if (this.mode == Mode.ECB) {
            return this.doFinalWithECB(data);
        }
        if (this.mode == Mode.CBC) {
            return this.doFinalWithCBC(data);
        }
        if (this.mode == Mode.CFB) {
            return this.doFinalWithCFB(data);
        }
        if (this.mode == Mode.OFB) {
            return this.doFinalWithOFB(data);
        }
        if (this.mode == Mode.CTR) {
            return this.doFinalWithCTR(data);
        }
        throw new IllegalStateException("can not support this mode[" + String.valueOf((Object)this.mode) + "]");
    }

    private byte[] doFinalWithECB(byte[] data) {
        byte[] outdata = new byte[data.length];
        for (int i = 0; i < data.length; i += 16) {
            this.sm4Func(this.workingKey, data, i, outdata, i);
        }
        return outdata;
    }

    private byte[] doFinalWithCBC(byte[] data) {
        byte[] outdata = new byte[data.length];
        byte[] wiv = this.iv;
        for (int i = 0; i < data.length; i += 16) {
            byte[] xordata;
            byte[] subdata = new byte[16];
            System.arraycopy(data, i, subdata, 0, 16);
            byte[] retdata = new byte[16];
            if (this.encryption) {
                xordata = this.xorBytes(wiv, subdata);
                this.sm4Func(this.workingKey, xordata, 0, retdata, 0);
                wiv = retdata;
                System.arraycopy(retdata, 0, outdata, i, 16);
                continue;
            }
            this.sm4Func(this.workingKey, subdata, 0, retdata, 0);
            xordata = this.xorBytes(wiv, retdata);
            wiv = subdata;
            System.arraycopy(xordata, 0, outdata, i, 16);
        }
        return outdata;
    }

    private byte[] doFinalWithCFB(byte[] data) {
        byte[] outdata = new byte[data.length];
        byte[] wiv = this.iv;
        for (int i = 0; i < data.length; i += 16) {
            byte[] xordata;
            byte[] subdata = new byte[16];
            System.arraycopy(data, i, subdata, 0, 16);
            byte[] retdata = new byte[16];
            if (this.encryption) {
                this.sm4Func(this.workingKey, wiv, 0, retdata, 0);
                xordata = this.xorBytes(subdata, retdata);
                wiv = xordata;
                System.arraycopy(xordata, 0, outdata, i, 16);
                continue;
            }
            this.sm4Func(this.workingKey, wiv, 0, retdata, 0);
            xordata = this.xorBytes(subdata, retdata);
            wiv = subdata;
            System.arraycopy(xordata, 0, outdata, i, 16);
        }
        return outdata;
    }

    private byte[] doFinalWithOFB(byte[] data) {
        byte[] outdata = new byte[data.length];
        byte[] wiv = this.iv;
        for (int i = 0; i < data.length; i += 16) {
            byte[] subdata = new byte[16];
            System.arraycopy(data, i, subdata, 0, 16);
            byte[] retdata = new byte[16];
            this.sm4Func(this.workingKey, wiv, 0, retdata, 0);
            byte[] xordata = this.xorBytes(subdata, retdata);
            wiv = retdata;
            System.arraycopy(xordata, 0, outdata, i, 16);
        }
        return outdata;
    }

    private byte[] doFinalWithCTR(byte[] data) {
        byte[] outdata = new byte[data.length];
        byte[] wiv = this.iv;
        block0: for (int i = 0; i < data.length; i += 16) {
            byte[] subdata = new byte[16];
            System.arraycopy(data, i, subdata, 0, 16);
            byte[] retdata = new byte[16];
            this.sm4Func(this.workingKey, wiv, 0, retdata, 0);
            byte[] xordata = this.xorBytes(subdata, retdata);
            System.arraycopy(xordata, 0, outdata, i, 16);
            for (int j = 15; j >= 0; --j) {
                int n = j;
                wiv[n] = (byte)(wiv[n] + 1);
                if (wiv[j] != 0) continue block0;
            }
        }
        return outdata;
    }

    byte[] xorBytes(byte[] prefix, byte[] suffix) {
        if (prefix == null || suffix == null || prefix.length != suffix.length) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[prefix.length];
        for (int i = 0; i < prefix.length; ++i) {
            bytes[i] = (byte)(prefix[i] ^ suffix[i]);
        }
        return bytes;
    }

    private void intToBytes(int in, byte[] out, int offsetOut) {
        out[offsetOut] = (byte)(in >>> 24);
        out[offsetOut + 1] = (byte)(in >>> 16);
        out[offsetOut + 2] = (byte)(in >>> 8);
        out[offsetOut + 3] = (byte)in;
    }

    private int bytesToInt(byte[] in, int offset) {
        return (in[offset] & 0xFF) << 24 | (in[offset + 1] & 0xFF) << 16 | (in[offset + 2] & 0xFF) << 8 | in[offset + 3] & 0xFF;
    }

    private int leftShift(int in, int shiftBits) {
        return in << shiftBits | in >>> 32 - shiftBits;
    }

    private int transformL(int in) {
        return in ^ this.leftShift(in, 2) ^ this.leftShift(in, 10) ^ this.leftShift(in, 18) ^ this.leftShift(in, 24);
    }

    private int transformLEX(int in) {
        return in ^ this.leftShift(in, 13) ^ this.leftShift(in, 23);
    }

    private int transformT(int in) {
        return (Sbox[in >>> 24 & 0xFF] & 0xFF) << 24 | (Sbox[in >>> 16 & 0xFF] & 0xFF) << 16 | (Sbox[in >>> 8 & 0xFF] & 0xFF) << 8 | Sbox[in & 0xFF] & 0xFF;
    }

    private int compSwapT(int in, boolean flag) {
        if (flag) {
            return this.transformL(this.transformT(in));
        }
        return this.transformLEX(this.transformT(in));
    }

    private int roundF(int x0, int x1, int x2, int x3, int rk) {
        return x0 ^ this.compSwapT(x1 ^ x2 ^ x3 ^ rk, true);
    }

    protected int[] generateWorkingKey(boolean encrypting, byte[] key) {
        int i;
        int[] rk = new int[32];
        int[] MK = new int[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            MK[i2] = this.bytesToInt(key, i2 * 4);
        }
        int[] K = new int[4];
        for (i = 0; i < 4; ++i) {
            K[i] = MK[i] ^ FK[i];
        }
        if (encrypting) {
            for (i = 0; i < 32; i += 4) {
                rk[i] = K[0] = K[0] ^ this.compSwapT(K[1] ^ K[2] ^ K[3] ^ CK[i], false);
                rk[i + 1] = K[1] = K[1] ^ this.compSwapT(K[2] ^ K[3] ^ K[0] ^ CK[i + 1], false);
                rk[i + 2] = K[2] = K[2] ^ this.compSwapT(K[3] ^ K[0] ^ K[1] ^ CK[i + 2], false);
                rk[i + 3] = K[3] = K[3] ^ this.compSwapT(K[0] ^ K[1] ^ K[2] ^ CK[i + 3], false);
            }
        } else {
            for (i = 31; i > 0; i -= 4) {
                rk[i] = K[0] = K[0] ^ this.compSwapT(K[1] ^ K[2] ^ K[3] ^ CK[31 - i], false);
                rk[i - 1] = K[1] = K[1] ^ this.compSwapT(K[2] ^ K[3] ^ K[0] ^ CK[32 - i], false);
                rk[i - 2] = K[2] = K[2] ^ this.compSwapT(K[3] ^ K[0] ^ K[1] ^ CK[33 - i], false);
                rk[i - 3] = K[3] = K[3] ^ this.compSwapT(K[0] ^ K[1] ^ K[2] ^ CK[34 - i], false);
            }
        }
        return rk;
    }

    protected void sm4Func(int[] wKey, byte[] in, int inOff, byte[] out, int outOff) {
        int i;
        int[] X = new int[4];
        for (i = 0; i < 4; ++i) {
            X[i] = this.bytesToInt(in, inOff + i * 4);
        }
        for (i = 0; i < 32; i += 4) {
            X[0] = this.roundF(X[0], X[1], X[2], X[3], wKey[i]);
            X[1] = this.roundF(X[1], X[2], X[3], X[0], wKey[i + 1]);
            X[2] = this.roundF(X[2], X[3], X[0], X[1], wKey[i + 2]);
            X[3] = this.roundF(X[3], X[0], X[1], X[2], wKey[i + 3]);
        }
        for (i = 3; i >= 0; --i) {
            this.intToBytes(X[i], out, outOff + (3 - i) * 4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        ECB,
        CBC,
        OFB,
        CFB,
        CTR;

    }
}

