/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.symmetric;

import io.soft.algorithm.crypto.BlockCipher;
import io.soft.algorithm.crypto.BufferedBlockCipher;
import io.soft.algorithm.crypto.engines.SM4Engine;
import io.soft.algorithm.crypto.modes.CBCBlockCipher;
import io.soft.algorithm.crypto.modes.CFBBlockCipher;
import io.soft.algorithm.crypto.modes.GCMBlockCipher;
import io.soft.algorithm.crypto.modes.OFBBlockCipher;
import io.soft.algorithm.crypto.modes.SICBlockCipher;
import io.soft.algorithm.crypto.paddings.BlockCipherPadding;
import io.soft.algorithm.crypto.paddings.PaddedBufferedBlockCipher;
import io.soft.algorithm.crypto.params.AEADParameters;
import io.soft.algorithm.crypto.params.KeyParameter;
import io.soft.algorithm.crypto.params.ParametersWithIV;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;

public class SM4 {
    public static byte[] selectMode(BlockCipher blockCipher, byte[] key, byte[] plaintext, byte[] iv, boolean forEncryption, BlockCipherPadding padding) {
        Checker.check(key != null, "SM4 secret key cannot be null.", new Object[0]);
        Checker.check(key.length == 16, "SM4 secret key error, must be 16 bytes.", new Object[0]);
        BufferedBlockCipher b = padding == null ? new BufferedBlockCipher(blockCipher) : new PaddedBufferedBlockCipher(blockCipher, padding);
        KeyParameter kp = new KeyParameter(key);
        if (iv == null) {
            b.init(forEncryption, kp);
        } else {
            ParametersWithIV cipherParameters = new ParametersWithIV(kp, iv);
            b.init(forEncryption, cipherParameters);
        }
        byte[] out = new byte[b.getOutputSize(plaintext.length)];
        int len = b.processBytes(plaintext, 0, plaintext.length, out, 0);
        int resultLen = b.doFinal(out, len);
        if (!forEncryption && padding != null) {
            byte[] res = new byte[(out.length / 16 - 1) * 16 + resultLen];
            System.arraycopy(out, 0, res, 0, res.length);
            return res;
        }
        return out;
    }

    public static byte[] doFinalWithECB(byte[] data, byte[] key, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(data != null, "the plain text for SM4 cipher cannot be null.", new Object[0]);
        Checker.check(data.length % 16 == 0 || padding != null, "the length of plain text for SM4 cipher not block size aligned.", new Object[0]);
        SM4Engine b = new SM4Engine();
        return SM4.selectMode(b, key, data, null, forEncryption, padding);
    }

    public static byte[] doFinalWithCBC(byte[] data, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(data != null, "the plain text for SM4 cipher cannot be null.", new Object[0]);
        Checker.check(data.length % 16 == 0 || padding != null, "the length of plain text for SM4 cipher not block size aligned.", new Object[0]);
        CBCBlockCipher b = new CBCBlockCipher(new SM4Engine());
        return SM4.selectMode(b, key, data, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithOFB(byte[] plaintext, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(plaintext != null, "the plain text for SM4 cipher cannot be null.", new Object[0]);
        OFBBlockCipher b = new OFBBlockCipher(new SM4Engine(), 128);
        return SM4.selectMode(b, key, plaintext, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithCFB(byte[] plaintext, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(plaintext != null, "the plain text for SM4 cipher cannot be null.", new Object[0]);
        CFBBlockCipher b = new CFBBlockCipher(new SM4Engine(), 128);
        return SM4.selectMode(b, key, plaintext, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithCTR(byte[] plaintext, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(plaintext != null, "the plain text for SM4 cipher cannot be null.", new Object[0]);
        Checker.check(plaintext.length % 16 == 0 || padding != null, "the length of plain text for SM4 cipher not block size aligned.", new Object[0]);
        SICBlockCipher b = new SICBlockCipher(new SM4Engine());
        return SM4.selectMode(b, key, plaintext, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithGCM(byte[] input, byte[] key, byte[] iv, byte[] aad, boolean forEncryption) {
        Checker.check(key != null, "SM4 secret key cannot be null.", new Object[0]);
        Checker.check(key.length == 16, "the sm4 key for GCM mode must be 16 byte.", new Object[0]);
        Checker.check(input != null, "the data for sm4 cipher with gcm mode can not be null.", new Object[0]);
        GCMBlockCipher blockCipher = new GCMBlockCipher(new SM4Engine());
        KeyParameter keyParameter = new KeyParameter(key);
        AEADParameters cipherParameters = new AEADParameters(keyParameter, 128, iv, aad);
        blockCipher.init(forEncryption, cipherParameters);
        byte[] out = new byte[blockCipher.getOutputSize(input.length)];
        int len = blockCipher.processBytes(input, 0, input.length, out, 0);
        blockCipher.doFinal(len, out);
        return out;
    }
}

