/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.symmetric;

import io.soft.algorithm.crypto.BlockCipher;
import io.soft.algorithm.crypto.BufferedBlockCipher;
import io.soft.algorithm.crypto.engines.DESedeEngine;
import io.soft.algorithm.crypto.modes.CBCBlockCipher;
import io.soft.algorithm.crypto.modes.CFBBlockCipher;
import io.soft.algorithm.crypto.modes.OFBBlockCipher;
import io.soft.algorithm.crypto.modes.SICBlockCipher;
import io.soft.algorithm.crypto.paddings.BlockCipherPadding;
import io.soft.algorithm.crypto.paddings.PaddedBufferedBlockCipher;
import io.soft.algorithm.crypto.params.KeyParameter;
import io.soft.algorithm.crypto.params.ParametersWithIV;
import io.soft.algorithm.exception.AlgorithmCallingException;
import io.soft.algorithm.util.Checker;

public class DESede {
    public static byte[] selectMode(BlockCipher blockCipher, byte[] key, byte[] plaintext, byte[] iv, boolean forEncryption, BlockCipherPadding padding) {
        Checker.check(key != null, "DESede secret key cannot be null.", new Object[0]);
        if (key.length == 8) {
            byte[] newKey = new byte[key.length * 3];
            System.arraycopy(key, 0, newKey, 0, 8);
            System.arraycopy(key, 0, newKey, 8, 8);
            System.arraycopy(key, 0, newKey, 16, 8);
            key = newKey;
        }
        BufferedBlockCipher b = padding == null ? new BufferedBlockCipher(blockCipher) : new PaddedBufferedBlockCipher(blockCipher, padding);
        KeyParameter kp = new KeyParameter(key);
        if (iv == null) {
            b.init(forEncryption, kp);
        } else {
            ParametersWithIV cipherParameters = new ParametersWithIV(kp, iv);
            b.init(forEncryption, cipherParameters);
        }
        byte[] out = new byte[b.getOutputSize(plaintext.length)];
        int len = b.processBytes(plaintext, 0, plaintext.length, out, 0);
        int resultLen = b.doFinal(out, len);
        if (!forEncryption && padding != null) {
            byte[] res = new byte[(out.length / 8 - 1) * 8 + resultLen];
            System.arraycopy(out, 0, res, 0, res.length);
            return res;
        }
        return out;
    }

    public static byte[] doFinalWithECB(byte[] data, byte[] key, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(data != null, "the plain text for DESede cipher cannot be null.", new Object[0]);
        DESedeEngine b = new DESedeEngine();
        Checker.check(data.length % b.getBlockSize() == 0 || padding != null, "the length of plain text for DESede cipher not block size aligned.", new Object[0]);
        return DESede.selectMode(b, key, data, null, forEncryption, padding);
    }

    public static byte[] doFinalWithCBC(byte[] data, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(data != null, "the plain text for DESede cipher cannot be null.", new Object[0]);
        CBCBlockCipher b = new CBCBlockCipher(new DESedeEngine());
        Checker.check(data.length % b.getBlockSize() == 0 || padding != null, "the length of plain text for DESede cipher not block size aligned.", new Object[0]);
        return DESede.selectMode(b, key, data, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithOFB(byte[] plaintext, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(plaintext != null, "the plain text for DESede cipher cannot be null.", new Object[0]);
        OFBBlockCipher b = new OFBBlockCipher(new DESedeEngine(), 64);
        return DESede.selectMode(b, key, plaintext, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithCFB(byte[] plaintext, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(plaintext != null, "the plain text for DESede cipher cannot be null.", new Object[0]);
        CFBBlockCipher b = new CFBBlockCipher(new DESedeEngine(), 64);
        return DESede.selectMode(b, key, plaintext, iv, forEncryption, padding);
    }

    public static byte[] doFinalWithCTR(byte[] plaintext, byte[] key, byte[] iv, boolean forEncryption, BlockCipherPadding padding) throws AlgorithmCallingException {
        Checker.check(plaintext != null, "the plain text for DESede cipher cannot be null.", new Object[0]);
        SICBlockCipher b = new SICBlockCipher(new DESedeEngine());
        Checker.check(plaintext.length % b.getBlockSize() == 0 || padding != null, "the length of plain text for DESede cipher not block size aligned.", new Object[0]);
        return DESede.selectMode(b, key, plaintext, iv, forEncryption, padding);
    }
}

