/*
 * Decompiled with CFR 0.152.
 */
package io.soft.algorithm.crypto.params;

import io.soft.algorithm.crypto.AsymmetricCipherKeyPairGenerator;
import io.soft.algorithm.crypto.CryptoServicesRegistrar;
import io.soft.algorithm.crypto.params.AsymmetricCipherKeyPair;
import io.soft.algorithm.crypto.params.ECDomainParameters;
import io.soft.algorithm.crypto.params.ECKeyGenerationParameters;
import io.soft.algorithm.crypto.params.ECPrivateKeyParameters;
import io.soft.algorithm.crypto.params.ECPublicKeyParameters;
import io.soft.algorithm.crypto.params.KeyGenerationParameters;
import io.soft.algorithm.math.ec.ECConstants;
import io.soft.algorithm.math.ec.ECMultiplier;
import io.soft.algorithm.math.ec.ECPoint;
import io.soft.algorithm.math.ec.FixedPointCombMultiplier;
import io.soft.algorithm.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, this.random)).compareTo(TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

